/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.geom.AffineTransform;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;

public class BufferedContext {
    protected RenderQueue rq;
    protected RenderBuffer buf;
    protected static BufferedContext currentContext;
    private SurfaceData validatedSrcData;
    private SurfaceData validatedDstData;
    private Region validatedClip;
    private Composite validatedComp;
    private int validatedPixel;
    private int validatedFlags;
    private boolean xformInUse;

    protected BufferedContext(RenderQueue renderQueue) {
        this.rq = renderQueue;
        this.buf = renderQueue.getBuffer();
    }

    public void validate(SurfaceData surfaceData, SurfaceData surfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        boolean bl;
        boolean bl2 = region != this.validatedClip;
        boolean bl3 = bl = n != this.validatedPixel;
        if (!surfaceData2.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (currentContext != this || surfaceData != this.validatedSrcData || surfaceData2 != this.validatedDstData) {
            if (surfaceData2 != this.validatedDstData) {
                bl2 = true;
            }
            if (n == 0) {
                bl = true;
            }
            this.setSurfaces(surfaceData, surfaceData2);
            currentContext = this;
            this.validatedSrcData = surfaceData;
            this.validatedDstData = surfaceData2;
        }
        if (bl2) {
            if (region != null) {
                this.setClip(region);
            } else {
                this.resetClip();
            }
            this.validatedClip = region;
        }
        if (composite != this.validatedComp || n2 != this.validatedFlags) {
            if (composite != null) {
                this.setComposite(composite, n2);
            } else {
                this.resetComposite();
            }
            bl = true;
            this.validatedComp = composite;
            this.validatedFlags = n2;
        }
        if (affineTransform == null) {
            if (this.xformInUse) {
                this.resetTransform();
                this.xformInUse = false;
            }
        } else {
            this.setTransform(affineTransform);
            this.xformInUse = true;
        }
        if (bl) {
            this.setColor(n);
            this.validatedPixel = n;
        }
        surfaceData2.markDirty();
    }

    public void invalidateSurfaces() {
        this.validatedSrcData = null;
        this.validatedDstData = null;
    }

    private void setSurfaces(SurfaceData surfaceData, SurfaceData surfaceData2) {
        this.rq.ensureCapacityAndAlignment(20, 4);
        this.buf.putInt(70);
        this.buf.putLong(surfaceData.getNativeOps());
        this.buf.putLong(surfaceData2.getNativeOps());
    }

    private void resetClip() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(55);
    }

    private void setClip(Region region) {
        if (region.isRectangular()) {
            this.rq.ensureCapacity(20);
            this.buf.putInt(51);
            this.buf.putInt(region.getLoX()).putInt(region.getLoY());
            this.buf.putInt(region.getHiX()).putInt(region.getHiY());
        } else {
            this.rq.ensureCapacity(28);
            this.buf.putInt(52);
            this.buf.putInt(53);
            int n = this.buf.position();
            this.buf.putInt(0);
            int n2 = 0;
            int n3 = this.buf.remaining() / 16;
            int[] nArray = new int[4];
            SpanIterator spanIterator = region.getSpanIterator();
            while (spanIterator.nextSpan(nArray)) {
                if (n3 == 0) {
                    this.buf.putInt(n, n2);
                    this.rq.flushNow();
                    this.buf.putInt(53);
                    n = this.buf.position();
                    this.buf.putInt(0);
                    n2 = 0;
                    n3 = this.buf.remaining() / 16;
                }
                this.buf.putInt(nArray[0]);
                this.buf.putInt(nArray[1]);
                this.buf.putInt(nArray[2]);
                this.buf.putInt(nArray[3]);
                ++n2;
                --n3;
            }
            this.buf.putInt(n, n2);
            this.rq.ensureCapacity(4);
            this.buf.putInt(54);
        }
    }

    private void resetComposite() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(58);
    }

    private void setComposite(Composite composite, int n) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.rq.ensureCapacity(16);
            this.buf.putInt(56);
            this.buf.putInt(alphaComposite.getRule());
            this.buf.putFloat(alphaComposite.getAlpha());
            this.buf.putInt(n);
        } else if (composite instanceof XORComposite) {
            int n2 = ((XORComposite)composite).getXorPixel();
            this.rq.ensureCapacity(8);
            this.buf.putInt(57);
            this.buf.putInt(n2);
        } else {
            throw new InternalError("not yet implemented");
        }
    }

    private void resetTransform() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(60);
    }

    private void setTransform(AffineTransform affineTransform) {
        this.rq.ensureCapacityAndAlignment(52, 4);
        this.buf.putInt(59);
        this.buf.putDouble(affineTransform.getScaleX());
        this.buf.putDouble(affineTransform.getShearY());
        this.buf.putDouble(affineTransform.getShearX());
        this.buf.putDouble(affineTransform.getScaleY());
        this.buf.putDouble(affineTransform.getTranslateX());
        this.buf.putDouble(affineTransform.getTranslateY());
    }

    private void setColor(int n) {
        this.rq.ensureCapacity(8);
        this.buf.putInt(50);
        this.buf.putInt(n);
    }
}

