/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.TexturePaint;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLRenderer;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.RenderBuffer;

abstract class OGLMaskFill
extends MaskFill {
    private final boolean isSimpleColor;

    static void register() {
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[]{new Solid(SurfaceType.AnyColor, CompositeType.SrcOver), new Solid(SurfaceType.OpaqueColor, CompositeType.SrcNoEa), new Gradient(SurfaceType.GradientPaint, CompositeType.SrcOver), new Gradient(SurfaceType.OpaqueGradientPaint, CompositeType.SrcNoEa), new Texture(SurfaceType.TexturePaint, CompositeType.SrcOver), new Texture(SurfaceType.OpaqueTexturePaint, CompositeType.SrcNoEa)};
        GraphicsPrimitiveMgr.register(graphicsPrimitiveArray);
    }

    protected OGLMaskFill(SurfaceType surfaceType, CompositeType compositeType, boolean bl) {
        super(surfaceType, compositeType, OGLSurfaceData.OpenGLSurface);
        this.isSimpleColor = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MaskFill(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Composite composite, final int n, final int n2, final int n3, final int n4, final byte[] byArray, final int n5, final int n6) {
        AlphaComposite alphaComposite = (AlphaComposite)composite;
        if (alphaComposite.getRule() != 3) {
            composite = AlphaComposite.SrcOver;
        }
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            this.validateOperation(sunGraphics2D, composite);
            RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
            if (byArray != null) {
                int n7 = byArray.length + 3 & 0xFFFFFFFC;
                int n8 = n7 - byArray.length;
                int n9 = 36 + n7;
                if (n9 <= renderBuffer.capacity()) {
                    if (n9 > renderBuffer.remaining()) {
                        oGLRenderQueue.flushNow();
                    }
                    renderBuffer.putInt(32);
                    renderBuffer.putInt(this.isSimpleColor ? 1 : 0);
                    renderBuffer.putInt(n).putInt(n2).putInt(n3).putInt(n4);
                    renderBuffer.putInt(n5);
                    renderBuffer.putInt(n6);
                    renderBuffer.putInt(n7);
                    renderBuffer.put(byArray);
                    if (n8 != 0) {
                        renderBuffer.position(renderBuffer.position() + n8);
                    }
                } else {
                    oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                        public void run() {
                            OGLMaskFill.this.maskFill(OGLMaskFill.this.isSimpleColor, n, n2, n3, n4, n5, n6, byArray.length, byArray);
                        }
                    });
                }
            } else {
                oGLRenderQueue.ensureCapacity(20);
                renderBuffer.putInt(20);
                renderBuffer.putInt(n).putInt(n2).putInt(n3).putInt(n4);
            }
            this.completeOperation();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    private native void maskFill(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9);

    protected void validateOperation(SunGraphics2D sunGraphics2D, int n, Composite composite) {
        OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
        OGLContext.validateContext(oGLSurfaceData, oGLSurfaceData, sunGraphics2D.getCompClip(), composite, null, n, 0);
    }

    protected abstract void validateOperation(SunGraphics2D var1, Composite var2);

    protected abstract void completeOperation();

    private static class Gradient
    extends OGLMaskFill {
        protected Gradient(SurfaceType surfaceType, CompositeType compositeType) {
            super(surfaceType, compositeType, false);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D, Composite composite) {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            GradientPaint gradientPaint = (GradientPaint)sunGraphics2D.paint;
            int n = OGLContext.getExtraAlphaPixel(composite);
            this.validateOperation(sunGraphics2D, n, composite);
            OGLRenderer.Gradient.enableGradientPaint(oGLRenderQueue, sunGraphics2D, gradientPaint);
        }

        protected void completeOperation() {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            OGLRenderer.Gradient.disableGradientPaint(oGLRenderQueue);
        }
    }

    private static class Solid
    extends OGLMaskFill {
        protected Solid(SurfaceType surfaceType, CompositeType compositeType) {
            super(surfaceType, compositeType, true);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D, Composite composite) {
            this.validateOperation(sunGraphics2D, sunGraphics2D.pixel, composite);
        }

        protected void completeOperation() {
        }
    }

    private static class Texture
    extends OGLMaskFill {
        protected Texture(SurfaceType surfaceType, CompositeType compositeType) {
            super(surfaceType, compositeType, false);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D, Composite composite) {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            int n = OGLContext.getExtraAlphaPixel(composite);
            this.validateOperation(sunGraphics2D, n, composite);
            OGLRenderer.Texture.enableTexturePaint(oGLRenderQueue, sunGraphics2D, texturePaint);
        }

        protected void completeOperation() {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            OGLRenderer.Texture.disableTexturePaint(oGLRenderQueue);
        }
    }
}

