/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.Localizer;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private final String key;
    private final Object[] args;

    protected JAXWSExceptionBase(String string, Object ... objectArray) {
        super(JAXWSExceptionBase.findNestedException(objectArray));
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.key = string;
        this.args = objectArray;
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        super(throwable);
        this.key = Localizable.NOT_LOCALIZABLE;
        this.args = new Object[]{throwable.toString()};
    }

    private static Throwable findNestedException(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            if (!(object instanceof Throwable)) continue;
            return (Throwable)object;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }
}

