/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContextUtil {
    public static Integer getHttpStatusCode(MessageContext messageContext) {
        return (Integer)messageContext.get("javax.xml.ws.http.response.code");
    }

    public static void setHttpStatusCode(MessageContext messageContext, Integer n) {
        messageContext.put("javax.xml.ws.http.response.code", n);
        messageContext.setScope("javax.xml.ws.http.response.code", MessageContext.Scope.APPLICATION);
    }

    public static void setQueryString(MessageContext messageContext, String string) {
        messageContext.put("javax.xml.ws.http.request.querystring", string);
        messageContext.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
    }

    public static void setPathInfo(MessageContext messageContext, String string) {
        messageContext.put("javax.xml.ws.http.request.pathinfo", string);
        messageContext.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpExchange(MessageContext messageContext, HttpExchange httpExchange) {
        messageContext.put("com.sun.xml.internal.ws.http.exchange", httpExchange);
        messageContext.setScope("com.sun.xml.internal.ws.http.exchange", MessageContext.Scope.APPLICATION);
    }

    public static HttpExchange getHttpExchange(MessageContext messageContext) {
        return (HttpExchange)messageContext.get("com.sun.xml.internal.ws.http.exchange");
    }

    public static void setHttpRequestMethod(MessageContext messageContext, String string) {
        messageContext.put("javax.xml.ws.http.request.method", string);
        messageContext.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpRequestHeaders(MessageContext messageContext, Map<String, List<String>> map) {
        messageContext.put("javax.xml.ws.http.request.headers", map);
        messageContext.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpResponseHeaders(MessageContext messageContext, Map<String, List<String>> map) {
        messageContext.put("javax.xml.ws.http.response.headers", map);
        messageContext.setScope("javax.xml.ws.http.response.headers", MessageContext.Scope.APPLICATION);
    }

    public static Map<String, List<String>> getHttpResponseHeaders(MessageContext messageContext) {
        return (Map)messageContext.get("javax.xml.ws.http.response.headers");
    }

    public static void setWsdlOperation(MessageContext messageContext, QName qName) {
        messageContext.put("javax.xml.ws.wsdl.operation", qName);
        messageContext.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
    }

    private static Map<String, DataHandler> getMessageAttachments(MessageContext messageContext) {
        Object v;
        String string = "javax.xml.ws.binding.attachments.inbound";
        Boolean bl = (Boolean)messageContext.get("javax.xml.ws.handler.message.outbound");
        if (bl != null && bl.booleanValue()) {
            string = "javax.xml.ws.binding.attachments.outbound";
        }
        if ((v = messageContext.get(string)) == null) {
            HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
            messageContext.put(string, hashMap);
            messageContext.setScope(string, MessageContext.Scope.APPLICATION);
            return hashMap;
        }
        return (Map)v;
    }

    public static void copyInboundMessageAttachments(MessageContext messageContext, Iterator<AttachmentPart> iterator) throws SOAPException {
        Map<String, DataHandler> map = MessageContextUtil.getMessageAttachments(messageContext);
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = iterator.next();
            DataHandler dataHandler = new DataHandler(new ByteArrayDataSource(attachmentPart.getRawContentBytes(), attachmentPart.getContentType()));
            map.put(attachmentPart.getContentId(), dataHandler);
        }
    }

    public static void addMessageAttachment(MessageContext messageContext, String string, DataHandler dataHandler) {
        Map<String, DataHandler> map = MessageContextUtil.getMessageAttachments(messageContext);
        map.put(string, dataHandler);
    }

    public static boolean ignoreFaultInMessage(MessageContext messageContext) {
        if (messageContext.get("ignore fault in message") == null) {
            return false;
        }
        return (Boolean)messageContext.get("ignore fault in message");
    }
}

