/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.PredicatedNodeTest;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.axes.WalkingIterator;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
PathComponent,
ExpressionOwner {
    static final long serialVersionUID = -2966031951306601247L;
    private DTM m_dtm;
    transient int m_root = -1;
    private transient int m_currentNode = -1;
    transient boolean m_isFresh;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    protected int m_axis = -1;
    protected DTMAxisTraverser m_traverser;

    public AxesWalker(LocPathIterator locPathIterator, int n) {
        super(locPathIterator);
        this.m_axis = n;
    }

    public final WalkingIterator wi() {
        return (WalkingIterator)this.m_lpi;
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        this.initPredicateInfo(compiler, n);
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker axesWalker = (AxesWalker)super.clone();
        return axesWalker;
    }

    AxesWalker cloneDeep(WalkingIterator walkingIterator, Vector vector) throws CloneNotSupportedException {
        AxesWalker axesWalker = AxesWalker.findClone(this, vector);
        if (null != axesWalker) {
            return axesWalker;
        }
        axesWalker = (AxesWalker)this.clone();
        axesWalker.setLocPathIterator(walkingIterator);
        if (null != vector) {
            vector.addElement(this);
            vector.addElement(axesWalker);
        }
        if (this.wi().m_lastUsedWalker == this) {
            walkingIterator.m_lastUsedWalker = axesWalker;
        }
        if (null != this.m_nextWalker) {
            axesWalker.m_nextWalker = this.m_nextWalker.cloneDeep(walkingIterator, vector);
        }
        if (null != vector) {
            if (null != this.m_prevWalker) {
                axesWalker.m_prevWalker = this.m_prevWalker.cloneDeep(walkingIterator, vector);
            }
        } else if (null != this.m_nextWalker) {
            axesWalker.m_nextWalker.m_prevWalker = axesWalker;
        }
        return axesWalker;
    }

    static AxesWalker findClone(AxesWalker axesWalker, Vector vector) {
        if (null != vector) {
            int n = vector.size();
            for (int i = 0; i < n; i += 2) {
                if (axesWalker != vector.elementAt(i)) continue;
                return (AxesWalker)vector.elementAt(i + 1);
            }
        }
        return null;
    }

    public void detach() {
        this.m_currentNode = -1;
        this.m_dtm = null;
        this.m_traverser = null;
        this.m_isFresh = true;
        this.m_root = -1;
    }

    public int getRoot() {
        return this.m_root;
    }

    public int getAnalysisBits() {
        int n = this.getAxis();
        int n2 = WalkerFactory.getAnalysisBitFromAxes(n);
        return n2;
    }

    public void setRoot(int n) {
        XPathContext xPathContext = this.wi().getXPathContext();
        this.m_dtm = xPathContext.getDTM(n);
        this.m_traverser = this.m_dtm.getAxisTraverser(this.m_axis);
        this.m_isFresh = true;
        this.m_foundLast = false;
        this.m_root = n;
        this.m_currentNode = n;
        if (-1 == n) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_SETTING_WALKER_ROOT_TO_NULL", null));
        }
        this.resetProximityPositions();
    }

    public final int getCurrentNode() {
        return this.m_currentNode;
    }

    public void setNextWalker(AxesWalker axesWalker) {
        this.m_nextWalker = axesWalker;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public void setPrevWalker(AxesWalker axesWalker) {
        this.m_prevWalker = axesWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    private int returnNextNode(int n) {
        return n;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (this.m_isFresh) {
            this.m_currentNode = this.m_traverser.first(this.m_root);
            this.m_isFresh = false;
        } else if (-1 != this.m_currentNode) {
            this.m_currentNode = this.m_traverser.next(this.m_root, this.m_currentNode);
        }
        if (-1 == this.m_currentNode) {
            this.m_foundLast = true;
        }
        return this.m_currentNode;
    }

    public int nextNode() {
        int n = -1;
        AxesWalker axesWalker = this.wi().getLastUsedWalker();
        while (null != axesWalker) {
            n = axesWalker.getNextNode();
            if (-1 == n) {
                axesWalker = axesWalker.m_prevWalker;
                continue;
            }
            if (axesWalker.acceptNode(n) != 1) continue;
            if (null == axesWalker.m_nextWalker) {
                this.wi().setLastUsedWalker(axesWalker);
                break;
            }
            AxesWalker axesWalker2 = axesWalker;
            axesWalker = axesWalker.m_nextWalker;
            axesWalker.setRoot(n);
            axesWalker.m_prevWalker = axesWalker2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPos(XPathContext xPathContext) {
        AxesWalker axesWalker;
        int n = this.getProximityPosition();
        try {
            axesWalker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        axesWalker.setPredicateCount(axesWalker.getPredicateCount() - 1);
        axesWalker.setNextWalker(null);
        axesWalker.setPrevWalker(null);
        WalkingIterator walkingIterator = this.wi();
        AxesWalker axesWalker2 = walkingIterator.getLastUsedWalker();
        try {
            int n2;
            walkingIterator.setLastUsedWalker(axesWalker);
            while (-1 != (n2 = axesWalker.nextNode())) {
                ++n;
            }
        }
        finally {
            walkingIterator.setLastUsedWalker(axesWalker2);
        }
        return n;
    }

    public void setDefaultDTM(DTM dTM) {
        this.m_dtm = dTM;
    }

    public DTM getDTM(int n) {
        return this.wi().getXPathContext().getDTM(n);
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitStep(expressionOwner, this)) {
            this.callPredicateVisitors(xPathVisitor);
            if (null != this.m_nextWalker) {
                this.m_nextWalker.callVisitors(this, xPathVisitor);
            }
        }
    }

    public Expression getExpression() {
        return this.m_nextWalker;
    }

    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_nextWalker = (AxesWalker)expression;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        AxesWalker axesWalker = (AxesWalker)expression;
        return this.m_axis == axesWalker.m_axis;
    }
}

