/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.orbutil.threadpool.TimeoutException;
import com.sun.corba.se.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;

public class ThreadPoolImpl
implements ThreadPool {
    private static int threadCounter = 0;
    private WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private int minWorkerThreads = 0;
    private int maxWorkerThreads = 0;
    private long inactivityTimeout;
    private boolean boundedThreadPool = false;
    private long processedCount = 1L;
    private long totalTimeTaken = 0L;
    private Object lock = new Object();
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private ThreadGroup threadGroup;

    public ThreadPoolImpl(ThreadGroup threadGroup, String string) {
        this.inactivityTimeout = 120000L;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = threadGroup;
        this.name = string;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadPoolImpl(int n, int n2, long l, String string) {
        this.minWorkerThreads = n;
        this.maxWorkerThreads = n2;
        this.inactivityTimeout = l;
        this.boundedThreadPool = true;
        this.workQueue = new WorkQueueImpl(this);
        this.name = string;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        MonitoredObject monitoredObject = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject monitoredObject2 = monitoredObject.getChild("threadpool");
        if (monitoredObject2 == null) {
            monitoredObject2 = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            monitoredObject.addChild(monitoredObject2);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        monitoredObject2.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase longMonitoredAttributeBase = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase);
        LongMonitoredAttributeBase longMonitoredAttributeBase2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase2);
        LongMonitoredAttributeBase longMonitoredAttributeBase3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase3);
        LongMonitoredAttributeBase longMonitoredAttributeBase4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase4);
        LongMonitoredAttributeBase longMonitoredAttributeBase5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    public WorkQueue getWorkQueue(int n) throws NoSuchWorkQueueException {
        if (n != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyForAvailableWork(WorkQueue workQueue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.availableWorkerThreads == 0) {
                this.createWorkerThread();
            } else {
                workQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWorkerThread() {
        WorkerThread workerThread;
        Object object = this.lock;
        synchronized (object) {
            if (this.boundedThreadPool) {
                if (this.currentThreadCount >= this.maxWorkerThreads) {
                    return;
                }
                workerThread = new WorkerThread(this.threadGroup, this.getName());
                ++this.currentThreadCount;
            } else {
                workerThread = new WorkerThread(this.threadGroup, this.getName());
                ++this.currentThreadCount;
            }
        }
        try {
            workerThread.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        workerThread.start();
    }

    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int currentNumberOfThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfAvailableThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfBusyThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount - this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long averageWorkCompletionTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalTimeTaken / this.processedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long currentProcessedCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.processedCount;
        }
    }

    public String getName() {
        return this.name;
    }

    public int numberOfWorkQueues() {
        return 1;
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter++;
    }

    private class WorkerThread
    extends Thread {
        private Work currentWork;
        private int threadId;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        WorkerThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, "Idle");
            this.threadId = 0;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = string;
            this.setName(this.composeWorkerThreadName(string, "Idle"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        Object object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads++;
                        }
                        this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                        object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads--;
                            if (ThreadPoolImpl.this.availableWorkerThreads == 0 && ThreadPoolImpl.this.workQueue.workItemsInQueue() > 0) {
                                ThreadPoolImpl.this.createWorkerThread();
                            }
                        }
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, Integer.toString(this.threadId)));
                        long l = System.currentTimeMillis();
                        try {
                            this.currentWork.doWork();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        long l2 = System.currentTimeMillis();
                        Object object3 = ThreadPoolImpl.this.lock;
                        synchronized (object3) {
                            ThreadPoolImpl.this.totalTimeTaken += l2 - l;
                            ThreadPoolImpl.this.processedCount++;
                        }
                        this.currentWork = null;
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, "Idle"));
                    }
                }
                catch (TimeoutException timeoutException) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                        if (ThreadPoolImpl.this.currentThreadCount > ThreadPoolImpl.this.minWorkerThreads) {
                            ThreadPoolImpl.this.currentThreadCount--;
                            return;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
                catch (Throwable throwable) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
            }
        }

        private String composeWorkerThreadName(String string, String string2) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append("p: ").append(string);
            this.workerThreadName.append("; w: ").append(string2);
            return this.workerThreadName.toString();
        }
    }
}

