/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.gcj.RawData;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MappedByteBufferImpl;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class FileChannelImpl
extends FileChannel {
    public RawData map_address;
    int length;
    FileDescriptor fd;
    MappedByteBuffer buf;
    Object file_obj;

    public FileChannelImpl(FileDescriptor fd, boolean write, Object obj) {
        if (!(obj instanceof RandomAccessFile || obj instanceof FileInputStream || obj instanceof FileOutputStream)) {
            throw new InternalError();
        }
        this.fd = fd;
        this.file_obj = obj;
    }

    public FileChannelImpl() {
        this(new FileDescriptor(), true, null);
    }

    private native long implPosition();

    private native FileChannel implPosition(long var1);

    private native FileChannel implTruncate(long var1);

    private native RawData nio_mmap_file(long var1, long var3, int var5);

    private native void nio_unmmap_file(RawData var1, int var2);

    private native void nio_msync(RawData var1, int var2);

    public native long size() throws IOException;

    protected void implCloseChannel() throws IOException {
        if (this.map_address != null) {
            this.nio_unmmap_file(this.map_address, this.length);
            this.map_address = null;
        }
        if (this.file_obj instanceof RandomAccessFile) {
            RandomAccessFile o = (RandomAccessFile)this.file_obj;
            o.close();
        } else if (this.file_obj instanceof FileInputStream) {
            FileInputStream o = (FileInputStream)this.file_obj;
            o.close();
        } else if (this.file_obj instanceof FileOutputStream) {
            FileOutputStream o = (FileOutputStream)this.file_obj;
            o.close();
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.buf != null) {
            throw new Error("Accessing mapped buffers not implemented.");
        }
        return this.implRead(dst);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        long oldPosition = this.implPosition();
        this.position(position);
        int result = this.implRead(dst);
        this.implPosition(oldPosition);
        return result;
    }

    private int implRead(ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[dst.remaining()];
        int result = this.implRead(buffer, 0, buffer.length);
        if (result > 0) {
            dst.put(buffer, 0, result);
        }
        return result;
    }

    private native int implRead(byte[] var1, int var2, int var3) throws IOException;

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            result += (long)this.read(dsts[i]);
        }
        return result;
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.buf != null) {
            throw new Error("Accessing mapped buffers not implemented.");
        }
        return this.implWrite(src);
    }

    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        long oldPosition = this.implPosition();
        this.position(position);
        int result = this.implWrite(src);
        this.implPosition(oldPosition);
        return result;
    }

    private int implWrite(ByteBuffer src) throws IOException {
        byte[] buffer = new byte[src.remaining()];
        src.get(buffer, 0, buffer.length);
        return this.implWrite(buffer, 0, buffer.length);
    }

    private native int implWrite(byte[] var1, int var2, int var3) throws IOException;

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            result += (long)this.write(srcs[i]);
        }
        return result;
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        if (mode != FileChannel.MapMode.READ_ONLY && mode != FileChannel.MapMode.READ_WRITE && mode != FileChannel.MapMode.PRIVATE || position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int cmode = mode.m;
        this.map_address = this.nio_mmap_file(position, size, cmode);
        this.length = (int)size;
        this.buf = new MappedByteBufferImpl(this);
        return this.buf;
    }

    static MappedByteBuffer create_direct_mapped_buffer(RawData map_address, long length) throws IOException {
        FileChannelImpl ch = new FileChannelImpl();
        ch.map_address = map_address;
        ch.length = (int)length;
        ch.buf = new MappedByteBufferImpl(ch);
        return ch.buf;
    }

    public void force(boolean metaData) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.nio_msync(this.map_address, this.length);
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        this.read(buffer, position);
        buffer.flip();
        return target.write(buffer);
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        src.read(buffer);
        buffer.flip();
        return this.write(buffer, position);
    }

    public FileLock lock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (shared && this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        if (!shared && this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        throw new Error("Not implemented");
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition(newPosition);
    }

    public FileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        return this.implTruncate(size);
    }
}

