/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.geom.Rectangle2D;

public final class GlyphMetrics {
    public static final byte COMBINING = 2;
    public static final byte COMPONENT = 3;
    public static final byte LIGATURE = 1;
    public static final byte STANDARD = 0;
    public static final byte WHITESPACE = 4;
    private boolean horizontal;
    private float advanceX;
    private float advanceY;
    private Rectangle2D bounds;
    private byte glyphType;

    public GlyphMetrics(boolean horizontal, float advanceX, float advanceY, Rectangle2D bounds, byte glyphType) {
        this.horizontal = horizontal;
        this.advanceX = advanceX;
        this.advanceY = advanceY;
        this.bounds = bounds;
        this.glyphType = glyphType;
    }

    public GlyphMetrics(float advance, Rectangle2D bounds, byte glyphType) {
        this(true, advance, advance, bounds, glyphType);
    }

    public float getAdvance() {
        if (this.horizontal) {
            return this.advanceX;
        }
        return this.advanceY;
    }

    public float getAdvanceX() {
        return this.advanceX;
    }

    public float getAdvanceY() {
        return this.advanceY;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public float getLSB() {
        throw new Error("not implemented");
    }

    public float getRSB() {
        throw new Error("not implemented");
    }

    public int getType() {
        return this.glyphType;
    }

    public boolean isCombining() {
        return this.glyphType == 2;
    }

    public boolean isComponent() {
        return this.glyphType == 3;
    }

    public boolean isLigature() {
        return this.glyphType == 1;
    }

    public boolean isStandard() {
        return this.glyphType == 0;
    }

    public boolean isWhitespace() {
        return this.glyphType == 4;
    }
}

