/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.TripleKey;
import gnu.java.rmi.server.UnicastConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;

public class UnicastConnectionManager
implements Runnable,
ProtocolConstants {
    private static String localhost;
    private static Hashtable servers;
    private static Hashtable clients;
    private ArrayList connections;
    private volatile Thread serverThread;
    private ServerSocket ssock;
    String serverName;
    int serverPort;
    private static Thread scavenger;
    Object serverobj;
    private static RMISocketFactory defaultSocketFactory;
    private RMIServerSocketFactory serverFactory;
    private RMIClientSocketFactory clientFactory;
    private static int ncsock;
    private static int nssock;
    private static int ncmanager;
    private static int nsmanager;
    private static final boolean debug = false;
    private static final Object GLOBAL_LOCK;

    private static void startScavenger() {
        scavenger = new Thread(new Runnable(null){
            private /* synthetic */ UnicastConnectionManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                boolean liveon = true;
                while (liveon) {
                    try {
                        Thread.sleep(10000);
                    }
                    catch (InterruptedException _ie) {
                        break;
                    }
                    liveon = false;
                    Iterator iter = clients.values().iterator();
                    long l = System.currentTimeMillis();
                    try {
                        while (iter.hasNext()) {
                            ArrayList conns;
                            UnicastConnectionManager man = (UnicastConnectionManager)iter.next();
                            ArrayList arrayList = conns = man.connections;
                            synchronized (arrayList) {
                                Object last2;
                                try {
                                    for (int last2 = conns.size() - 1; last2 >= 0; --last2) {
                                        UnicastConnection conn = (UnicastConnection)conns.get(last2);
                                        if (UnicastConnection.isExpired(conn, l)) {
                                            conns.remove(last2);
                                            conn.disconnect();
                                            conn = null;
                                            continue;
                                        }
                                        liveon = true;
                                    }
                                    last2 = null;
                                }
                                catch (Throwable throwable) {
                                    last2 = null;
                                    throw throwable;
                                }
                            }
                        }
                    }
                    catch (ConcurrentModificationException cme) {
                        liveon = true;
                    }
                }
                scavenger = null;
            }
        });
        scavenger.setDaemon(true);
        scavenger.start();
    }

    private UnicastConnectionManager(String host, int port, RMIClientSocketFactory csf) {
        this.ssock = null;
        this.serverName = host;
        this.serverPort = port;
        this.serverFactory = null;
        this.clientFactory = csf;
        this.connections = new ArrayList();
    }

    private UnicastConnectionManager(int port, RMIServerSocketFactory ssf) {
        try {
            this.ssock = ssf.createServerSocket(port);
            this.serverPort = this.ssock.getLocalPort();
        }
        catch (IOException _) {
            try {
                this.ssock = ssf.createServerSocket(0);
                this.serverPort = this.ssock.getLocalPort();
            }
            catch (IOException __) {
                this.ssock = null;
                this.serverPort = 0;
            }
        }
        this.serverName = localhost;
        this.serverFactory = ssf;
        this.clientFactory = null;
    }

    public static synchronized UnicastConnectionManager getInstance(String host, int port, RMIClientSocketFactory csf) {
        if (csf == null) {
            csf = defaultSocketFactory;
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception key) {
            // empty catch block
        }
        TripleKey key = new TripleKey(host, port, csf);
        UnicastConnectionManager man = (UnicastConnectionManager)clients.get(key);
        if (man == null) {
            man = new UnicastConnectionManager(host, port, csf);
            clients.put(key, man);
            UnicastConnectionManager svrman = (UnicastConnectionManager)servers.get(key);
            if (svrman != null) {
                man.serverobj = svrman.serverobj;
            }
        }
        return man;
    }

    public static synchronized UnicastConnectionManager getInstance(int port, RMIServerSocketFactory ssf) {
        TripleKey key;
        UnicastConnectionManager man;
        if (ssf == null) {
            ssf = defaultSocketFactory;
        }
        if ((man = (UnicastConnectionManager)servers.get(key = new TripleKey(localhost, port, ssf))) == null) {
            man = new UnicastConnectionManager(port, ssf);
            key.port = man.serverPort;
            servers.put(key, man);
        }
        return man;
    }

    public UnicastConnection getConnection() throws IOException {
        if (this.ssock == null) {
            return this.getClientConnection();
        }
        return this.getServerConnection();
    }

    private UnicastConnection getServerConnection() throws IOException {
        Socket sock = this.ssock.accept();
        sock.setTcpNoDelay(true);
        UnicastConnection conn = new UnicastConnection(this, sock);
        conn.acceptConnection();
        return conn;
    }

    private UnicastConnection getClientConnection() throws IOException {
        UnicastConnection conn;
        ArrayList conns;
        ArrayList arrayList = conns = this.connections;
        synchronized (arrayList) {
            block4: {
                try {
                    int nconn = conns.size() - 1;
                    if (nconn < 0) break block4;
                    conn = (UnicastConnection)conns.get(nconn);
                    conns.remove(nconn);
                    long l = System.currentTimeMillis();
                    if (!UnicastConnection.isExpired(conn, l)) {
                        UnicastConnection unicastConnection = conn;
                        Object var8_8 = null;
                        return unicastConnection;
                    }
                    conn.disconnect();
                    conn = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    throw throwable;
                }
            }
            Object var8_9 = null;
        }
        Socket sock = this.clientFactory.createSocket(this.serverName, this.serverPort);
        conn = new UnicastConnection(this, sock);
        conn.makeConnection(75);
        UnicastConnection unicastConnection = conn;
        return unicastConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void discardConnection(UnicastConnection conn) {
        if (this.ssock == null) {
            UnicastConnection.resetTime(conn);
            Object object = GLOBAL_LOCK;
            synchronized (object) {
                try {
                    this.connections.add(conn);
                    if (scavenger != null) return;
                    UnicastConnectionManager.startScavenger();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
                return;
            }
        }
        conn.disconnect();
    }

    public void startServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            try {
                block6: {
                    block5: {
                        if (this.ssock == null) break block5;
                        if (this.serverThread == null) break block6;
                    }
                    Object var2_2 = null;
                    return;
                }
                this.serverThread = new Thread(this);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
            Object var2_3 = null;
        }
        this.serverThread.start();
    }

    public void stopServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            try {
                if (this.serverThread != null) {
                    this.serverThread = null;
                    try {
                        this.ssock.close();
                    }
                    catch (Exception exception) {
                    }
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    public void run() {
        while (this.serverThread != null) {
            try {
                UnicastConnection conn = this.getServerConnection();
                new Thread(conn).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.serverName);
        out.writeInt(this.serverPort);
    }

    static UnicastConnectionManager read(ObjectInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return UnicastConnectionManager.getInstance(host, port, null);
    }

    static {
        servers = new Hashtable();
        clients = new Hashtable();
        defaultSocketFactory = RMISocketFactory.getSocketFactory();
        ncsock = 0;
        nssock = 0;
        ncmanager = 0;
        nsmanager = 0;
        GLOBAL_LOCK = new Object();
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException _) {
            localhost = "localhost";
        }
    }
}

