/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.amd64;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.runtime.amd64.AMD64JavaCallWrapper;
import sun.jvm.hotspot.runtime.amd64.AMD64RegisterMap;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class AMD64Frame
extends Frame {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.amd64.AMD64Frame.DEBUG") != null;
    private static final int PC_RETURN_OFFSET = 0;
    private static final int LINK_OFFSET = 0;
    private static final int RETURN_ADDR_OFFSET = 1;
    private static final int SENDER_SP_OFFSET = 2;
    private static final int INTERPRETER_FRAME_MIRROR_OFFSET = 2;
    private static final int INTERPRETER_FRAME_SENDER_SP_OFFSET = -1;
    private static final int INTERPRETER_FRAME_LAST_SP_OFFSET = -2;
    private static final int INTERPRETER_FRAME_METHOD_OFFSET = -3;
    private static int INTERPRETER_FRAME_MDX_OFFSET;
    private static int INTERPRETER_FRAME_CACHE_OFFSET;
    private static int INTERPRETER_FRAME_LOCALS_OFFSET;
    private static int INTERPRETER_FRAME_BCX_OFFSET;
    private static int INTERPRETER_FRAME_INITIAL_SP_OFFSET;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET;
    private static final int ENTRY_FRAME_CALL_WRAPPER_OFFSET = -6;
    private static final int NATIVE_FRAME_INITIAL_PARAM_OFFSET = 2;
    Address raw_fp;

    private static synchronized void initialize(TypeDataBase db) {
        if (VM.getVM().isCore()) {
            INTERPRETER_FRAME_CACHE_OFFSET = -4;
        } else {
            INTERPRETER_FRAME_MDX_OFFSET = -4;
            INTERPRETER_FRAME_CACHE_OFFSET = INTERPRETER_FRAME_MDX_OFFSET - 1;
        }
        INTERPRETER_FRAME_LOCALS_OFFSET = INTERPRETER_FRAME_CACHE_OFFSET - 1;
        INTERPRETER_FRAME_BCX_OFFSET = INTERPRETER_FRAME_LOCALS_OFFSET - 1;
        INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET = INTERPRETER_FRAME_INITIAL_SP_OFFSET = INTERPRETER_FRAME_BCX_OFFSET - 1;
        INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET = INTERPRETER_FRAME_INITIAL_SP_OFFSET;
    }

    private AMD64Frame() {
    }

    public AMD64Frame(Address raw_sp, Address raw_fp, Address pc) {
        this.raw_sp = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = pc;
        if (DEBUG) {
            System.out.println("AMD64Frame(sp, fp, pc): " + this);
            this.dumpStack();
        }
    }

    public AMD64Frame(Address raw_sp, Address raw_fp) {
        this.raw_sp = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = raw_sp.getAddressAt(-1L * VM.getVM().getAddressSize());
        if (DEBUG) {
            System.out.println("AMD64Frame(sp, fp): " + this);
            this.dumpStack();
        }
    }

    public Object clone() {
        AMD64Frame frame = new AMD64Frame();
        frame.raw_sp = this.raw_sp;
        frame.raw_fp = this.raw_fp;
        frame.pc = this.pc;
        return frame;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof AMD64Frame)) {
            return false;
        }
        AMD64Frame other = (AMD64Frame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return ((Object)this.raw_sp).hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", fp: " + (this.getFP() == null ? "null" : this.getFP().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    public Address getFP() {
        return this.raw_fp;
    }

    public Address getSP() {
        return this.raw_sp;
    }

    public Address getID() {
        return this.raw_sp;
    }

    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    public int getSignalNumberDbg() {
        return 0;
    }

    public String getSignalNameDbg() {
        return null;
    }

    public boolean isInterpretedFrameValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        if (this.getFP() == null || this.getFP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getFP().addOffsetTo((long)INTERPRETER_FRAME_INITIAL_SP_OFFSET * VM.getVM().getAddressSize()).lessThan(this.getSP())) {
            return false;
        }
        if (this.getFP().lessThanOrEqual(this.getSP())) {
            return false;
        }
        return this.getFP().minus(this.getSP()) <= 4096L * VM.getVM().getAddressSize();
    }

    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        AMD64RegisterMap map = (AMD64RegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        if (this.isInterpretedFrame()) {
            return this.senderForInterpreterFrame(map);
        }
        if (!VM.getVM().isCore()) {
            if (cb == null) {
                cb = VM.getVM().getCodeCache().findBlob(this.getPC());
            } else if (Assert.ASSERTS_ENABLED) {
                Assert.that(cb.equals(VM.getVM().getCodeCache().findBlob(this.getPC())), "Must be the same");
            }
            if (cb != null) {
                return this.senderForCompiledFrame(map, cb);
            }
        }
        return new AMD64Frame(this.getSenderSP(), this.getLink(), this.getSenderPC());
    }

    private Frame senderForEntryFrame(AMD64RegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        AMD64JavaCallWrapper jcw = (AMD64JavaCallWrapper)this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        AMD64Frame fr = jcw.getLastJavaPC() != null ? new AMD64Frame(jcw.getLastJavaSP(), jcw.getLastJavaFP(), jcw.getLastJavaPC()) : new AMD64Frame(jcw.getLastJavaSP(), jcw.getLastJavaFP());
        map.clear();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map.getIncludeArgumentOops(), "should be set by clear");
        }
        return fr;
    }

    private Frame senderForInterpreterFrame(AMD64RegisterMap map) {
        Address sp = this.addressOfStackSlot(-1).getAddressAt(0L);
        return new AMD64Frame(sp, this.getLink(), this.getSenderPC());
    }

    private Frame senderForCompiledFrame(AMD64RegisterMap map, CodeBlob cb) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        Address sender_sp = null;
        if (VM.getVM().isClientCompiler()) {
            sender_sp = this.addressOfStackSlot(2);
        } else {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(cb.getFrameSize() >= 0L, "Compiled by Compiler1: do not use");
            }
            sender_sp = this.getSP().addOffsetTo(cb.getFrameSize());
        }
        Address sender_pc = sender_sp.getAddressAt(-1L * VM.getVM().getAddressSize());
        if (map.getUpdateMap() && cb.getOopMaps() != null) {
            OopMapSet.updateRegisterMap(this, cb, map, true);
        }
        if (VM.getVM().isClientCompiler()) {
            map.setIncludeArgumentOops(cb.callerMustGCArguments(map.getThread()));
        }
        Address saved_fp = null;
        if (VM.getVM().isClientCompiler()) {
            saved_fp = this.getFP().getAddressAt(0L);
        } else if (VM.getVM().isServerCompiler() && (VM.getVM().getInterpreter().contains(sender_pc) || VM.getVM().getStubRoutines().returnsToCallStub(sender_pc))) {
            saved_fp = sender_sp.getAddressAt(-2L * VM.getVM().getAddressSize());
        }
        return new AMD64Frame(sender_sp, saved_fp, sender_pc);
    }

    protected boolean hasSenderPD() {
        return true;
    }

    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    public Address getLink() {
        return this.addressOfStackSlot(0).getAddressAt(0L);
    }

    public Address getUnextendedSP() {
        return this.getSP();
    }

    public Address getSenderPCAddr() {
        return this.addressOfStackSlot(1);
    }

    public Address getSenderPC() {
        return this.getSenderPCAddr().getAddressAt(0L);
    }

    public Address getNativeParamAddr(int idx) {
        return this.addressOfStackSlot(2 + idx);
    }

    public Address getSenderSP() {
        return this.addressOfStackSlot(2);
    }

    public long getOopMapOffsetAdjustmentPD() {
        return 0L;
    }

    public Address compiledArgumentToLocationPD(VMReg reg, RegisterMap regMap, int argSize) {
        if (VM.getVM().isCore() || VM.getVM().isClientCompiler()) {
            throw new RuntimeException("Should not reach here");
        }
        return this.oopMapRegToLocation(reg, regMap);
    }

    public Address addressOfInterpreterFrameLocals() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_LOCALS_OFFSET);
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_BCX_OFFSET);
    }

    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        OopHandle methodHandle = this.addressOfInterpreterFrameMethod().getOopHandleAt(0L);
        Method method = (Method)VM.getVM().getObjectHeap().newOop(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameMDX() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_MDX_OFFSET);
    }

    public Address addressOfInterpreterFrameExpressionStack() {
        Address monitorEnd = this.interpreterFrameMonitorEnd().address();
        return monitorEnd.addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    public Address addressOfInterpreterFrameTOS() {
        return this.getSP();
    }

    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.addressOfStackSlot(-1).getAddressAt(0L);
    }

    public BasicObjectLock interpreterFrameMonitorBegin() {
        return new BasicObjectLock(this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET));
    }

    public BasicObjectLock interpreterFrameMonitorEnd() {
        Address result = this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET).getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(AddressOps.gt(this.getFP(), result), "result must <  than frame pointer");
            Assert.that(AddressOps.lte(this.getSP(), result), "result must >= than stack pointer");
        }
        return new BasicObjectLock(result);
    }

    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    public Address addressOfInterpreterFrameMethod() {
        return this.addressOfStackSlot(-3);
    }

    public Address addressOfInterpreterFrameCPCache() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_CACHE_OFFSET);
    }

    public JavaCallWrapper getEntryFrameCallWrapper() {
        return new AMD64JavaCallWrapper(this.addressOfStackSlot(-6).getAddressAt(0L));
    }

    protected Address addressOfSavedOopResult() {
        return this.getSP().addOffsetTo((long)(VM.getVM().isClientCompiler() ? 2 : 3) * VM.getVM().getAddressSize());
    }

    protected Address addressOfSavedReceiver() {
        return this.getSP().addOffsetTo(-4L * VM.getVM().getAddressSize());
    }

    private void dumpStack() {
        if (this.getFP() != null) {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getFP().addOffsetTo(5L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        } else {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getSP().addOffsetTo(20L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                AMD64Frame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

