/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import javax.crypto.SunJCE_b;
import javax.crypto.SunJCE_k;
import javax.crypto.SunJCE_m;
import javax.crypto.SunJCE_n;
import javax.crypto.SunJCE_s;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class Cipher {
    private static final Debug a = Debug.getInstance("jca", "Cipher");
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private Provider b;
    private CipherSpi c;
    private String d;
    private SunJCE_k e;
    private ExemptionMechanism f;
    private boolean g = false;
    private int h = 0;
    private static final String i = "2.5.29.15";
    private CipherSpi j;
    private Provider.Service k;
    private Iterator l;
    private List m;
    private final Object n;
    private static final String o = "SupportedModes";
    private static final String p = "SupportedPaddings";
    private static final int q = 0;
    private static final int r = 1;
    private static final int s = 2;
    private static int t = 10;
    private static final int u = 1;
    private static final int v = 2;
    private static final int w = 3;
    private static final int x = 4;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        if (!SunJCE_n.f.a()) {
            throw new NullPointerException();
        }
        this.c = cipherSpi;
        this.b = provider;
        this.d = string;
        this.e = SunJCE_s.b;
        this.n = null;
    }

    Cipher(CipherSpi cipherSpi, String string) {
        this.c = cipherSpi;
        this.d = string;
        this.e = SunJCE_s.b;
        this.n = null;
    }

    private Cipher(CipherSpi cipherSpi, Provider.Service service, Iterator iterator, String string, List list) {
        this.j = cipherSpi;
        this.k = service;
        this.l = iterator;
        this.m = list;
        this.d = string;
        this.n = new Object();
    }

    private static String[] a(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("No transformation given");
        }
        String[] stringArray = new String[3];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken().trim();
            }
            if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
        }
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            throw new NoSuchAlgorithmException("Invalid transformation:algorithm not specified-" + string);
        }
        return stringArray;
    }

    private static List b(String string) throws NoSuchAlgorithmException {
        String[] stringArray = Cipher.a(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string3 == null && string4 == null) {
            SunJCE_m sunJCE_m = new SunJCE_m(string2, "", null, null);
            return Collections.singletonList(sunJCE_m);
        }
        ArrayList<SunJCE_m> arrayList = new ArrayList<SunJCE_m>(4);
        arrayList.add(new SunJCE_m(string2, "/" + string3 + "/" + string4, null, null));
        arrayList.add(new SunJCE_m(string2, "/" + string3, null, string4));
        arrayList.add(new SunJCE_m(string2, "//" + string4, string3, null));
        arrayList.add(new SunJCE_m(string2, "", string3, string4));
        return arrayList;
    }

    private static SunJCE_m a(Provider.Service service, List list) {
        String string = service.getAlgorithm().toUpperCase(Locale.ENGLISH);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SunJCE_m sunJCE_m = (SunJCE_m)iterator.next();
            if (!string.endsWith(sunJCE_m.b)) continue;
            return sunJCE_m;
        }
        return null;
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Object object;
        List list = Cipher.b(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SunJCE_m)object2.next();
            arrayList.add(((SunJCE_m)object).a);
        }
        object2 = GetInstance.getServices("Cipher", arrayList);
        object = object2.iterator();
        Exception exception = null;
        while (object.hasNext()) {
            int n;
            SunJCE_m sunJCE_m;
            Provider.Service service = (Provider.Service)object.next();
            if (!SunJCE_b.b(service.getProvider()) || (sunJCE_m = Cipher.a(service, list)) == null || (n = sunJCE_m.a(service)) == 0) continue;
            if (n == 2) {
                return new Cipher(null, service, (Iterator)object, string, list);
            }
            try {
                CipherSpi cipherSpi = (CipherSpi)service.newInstance(null);
                sunJCE_m.a(cipherSpi);
                return new Cipher(cipherSpi, service, (Iterator)object, string, list);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new NoSuchAlgorithmException("Cannot find any provider supporting " + string, exception);
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Missing provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("No such provider: " + string2);
        }
        return Cipher.getInstance(string, provider);
    }

    public static final Cipher getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException("Missing provider");
        }
        Exception exception = null;
        List list = Cipher.b(string);
        boolean bl = false;
        String string2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            SunJCE_m sunJCE_m = (SunJCE_m)iterator.next();
            Provider.Service service = provider.getService("Cipher", sunJCE_m.a);
            if (service == null) continue;
            if (!bl) {
                object = SunJCE_b.a(provider);
                if (object != null) {
                    String string3 = "JCE cannot authenticate the provider " + provider.getName();
                    throw new SecurityException(string3, (Throwable)object);
                }
                bl = true;
            }
            if (sunJCE_m.b(service) == 0) continue;
            if (sunJCE_m.c(service) == 0) {
                string2 = sunJCE_m.d;
                continue;
            }
            try {
                object = (CipherSpi)service.newInstance(null);
                sunJCE_m.a((CipherSpi)object);
                Cipher cipher = new Cipher((CipherSpi)object, string);
                cipher.b = service.getProvider();
                cipher.b();
                return cipher;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception instanceof NoSuchPaddingException) {
            throw (NoSuchPaddingException)exception;
        }
        if (string2 != null) {
            throw new NoSuchPaddingException("Padding not supported: " + string2);
        }
        throw new NoSuchAlgorithmException("No such algorithm: " + string, exception);
    }

    private void b() throws NoSuchAlgorithmException {
        if (!SunJCE_b.c()) {
            this.e = SunJCE_s.b;
            this.f = null;
            return;
        }
        this.e = Cipher.c(this.d);
        String string = this.e.b();
        if (string != null) {
            this.f = ExemptionMechanism.getInstance(string);
        }
    }

    void a() {
        if (this.c != null) {
            return;
        }
        Object object = this.n;
        synchronized (object) {
            Object object2;
            int n;
            if (this.c != null) {
                return;
            }
            if (a != null && (n = --t) >= 0) {
                a.println("Cipher.init() not first method called, disabling delayed provider selection");
                if (n == 0) {
                    a.println("Further warnings of this type will be suppressed");
                }
                new Exception("Call trace").printStackTrace();
            }
            Exception exception = null;
            while (this.k != null || this.l.hasNext()) {
                SunJCE_m sunJCE_m;
                CipherSpi cipherSpi;
                if (this.k != null) {
                    object2 = this.k;
                    cipherSpi = this.j;
                    this.k = null;
                    this.j = null;
                } else {
                    object2 = (Provider.Service)this.l.next();
                    cipherSpi = null;
                }
                if (!SunJCE_b.b(((Provider.Service)object2).getProvider()) || (sunJCE_m = Cipher.a((Provider.Service)object2, this.m)) == null || sunJCE_m.a((Provider.Service)object2) == 0) continue;
                try {
                    if (cipherSpi == null) {
                        Object object3 = ((Provider.Service)object2).newInstance(null);
                        if (!(object3 instanceof CipherSpi)) continue;
                        cipherSpi = (CipherSpi)object3;
                    }
                    sunJCE_m.a(cipherSpi);
                    this.b();
                    this.c = cipherSpi;
                    this.b = ((Provider.Service)object2).getProvider();
                    this.k = null;
                    this.l = null;
                    this.m = null;
                    return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            object2 = new ProviderException("Could not construct CipherSpi instance");
            if (exception != null) {
                ((Throwable)object2).initCause(exception);
            }
            throw object2;
        }
    }

    private void a(CipherSpi cipherSpi, int n, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        switch (n) {
            case 1: {
                this.a(cipherSpi, key);
                cipherSpi.engineInit(n2, key, secureRandom);
                break;
            }
            case 2: {
                this.a(cipherSpi, key, algorithmParameterSpec);
                cipherSpi.engineInit(n2, key, algorithmParameterSpec, secureRandom);
                break;
            }
            case 3: {
                this.a(cipherSpi, key, algorithmParameters);
                cipherSpi.engineInit(n2, key, algorithmParameters, secureRandom);
                break;
            }
            case 4: {
                this.a(cipherSpi, key);
                cipherSpi.engineInit(n2, key, secureRandom);
                break;
            }
            default: {
                throw new AssertionError((Object)("Internal Cipher error: " + n));
            }
        }
    }

    private void a(int n, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.n;
        synchronized (object) {
            Object object2;
            if (this.c != null) {
                this.a(this.c, n, n2, key, algorithmParameterSpec, algorithmParameters, secureRandom);
                return;
            }
            Exception exception = null;
            while (this.k != null || this.l.hasNext()) {
                SunJCE_m sunJCE_m;
                CipherSpi cipherSpi;
                if (this.k != null) {
                    object2 = this.k;
                    cipherSpi = this.j;
                    this.k = null;
                    this.j = null;
                } else {
                    object2 = (Provider.Service)this.l.next();
                    cipherSpi = null;
                }
                if (!((Provider.Service)object2).supportsParameter(key) || !SunJCE_b.b(((Provider.Service)object2).getProvider()) || (sunJCE_m = Cipher.a((Provider.Service)object2, this.m)) == null || sunJCE_m.a((Provider.Service)object2) == 0) continue;
                try {
                    if (cipherSpi == null) {
                        cipherSpi = (CipherSpi)((Provider.Service)object2).newInstance(null);
                    }
                    sunJCE_m.a(cipherSpi);
                    this.b();
                    this.a(cipherSpi, n, n2, key, algorithmParameterSpec, algorithmParameters, secureRandom);
                    this.b = ((Provider.Service)object2).getProvider();
                    this.c = cipherSpi;
                    this.k = null;
                    this.l = null;
                    this.m = null;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            if (exception instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            object2 = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception);
        }
    }

    public final Provider getProvider() {
        this.a();
        return this.b;
    }

    public final String getAlgorithm() {
        return this.d;
    }

    public final int getBlockSize() {
        this.a();
        return this.c.engineGetBlockSize();
    }

    public final int getOutputSize(int n) {
        if (!this.g && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        this.a();
        return this.c.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        this.a();
        return this.c.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        this.a();
        return this.c.engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        this.a();
        return this.f;
    }

    private void a(CipherSpi cipherSpi, Key key) throws InvalidKeyException {
        AlgorithmParameterSpec algorithmParameterSpec;
        if (this.e == SunJCE_s.b) {
            return;
        }
        try {
            algorithmParameterSpec = this.a(cipherSpi.engineGetParameters());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException("Unsupported default algorithm parameters");
        }
        if (!this.b(cipherSpi, key, algorithmParameterSpec)) {
            throw new InvalidKeyException("Illegal key size or default parameters");
        }
    }

    private void a(CipherSpi cipherSpi, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.e == SunJCE_s.b) {
            return;
        }
        if (!this.b(cipherSpi, key, null)) {
            throw new InvalidKeyException("Illegal key size");
        }
        if (algorithmParameterSpec != null && !this.b(cipherSpi, key, algorithmParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Illegal parameters");
        }
    }

    private void a(CipherSpi cipherSpi, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        if (this.e == SunJCE_s.b) {
            return;
        }
        try {
            algorithmParameterSpec = this.a(algorithmParameters);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
        }
        this.a(cipherSpi, key, algorithmParameterSpec);
    }

    private boolean b(CipherSpi cipherSpi, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        String string = this.e.b();
        int n = cipherSpi.engineGetKeySize(key);
        int n2 = this.d.indexOf(47);
        String string2 = n2 != -1 ? this.d.substring(0, n2) : this.d;
        SunJCE_k sunJCE_k = new SunJCE_k(string2, n, algorithmParameterSpec, string);
        if (!this.e.implies(sunJCE_k)) {
            if (a != null) {
                a.println("Crypto Permission check failed");
                a.println("granted: " + this.e);
                a.println("requesting: " + sunJCE_k);
            }
            return false;
        }
        if (this.f == null) {
            return true;
        }
        try {
            if (!this.f.isCryptoAllowed(key)) {
                if (a != null) {
                    a.println(this.f.getName() + " isn't enforced");
                }
                return false;
            }
        }
        catch (ExemptionMechanismException exemptionMechanismException) {
            if (a != null) {
                a.println("Cannot determine whether " + this.f.getName() + " has been enforced");
                exemptionMechanismException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private static void a(int n) {
        if (n < 1 || n > 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.init(n, key, SunJCE_b.b);
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.g = false;
        Cipher.a(n);
        if (this.c != null) {
            this.a(this.c, key);
            this.c.engineInit(n, key, secureRandom);
        } else {
            try {
                this.a(1, n, key, null, null, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException);
            }
        }
        this.g = true;
        this.h = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, SunJCE_b.b);
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.g = false;
        Cipher.a(n);
        if (this.c != null) {
            this.a(this.c, key, algorithmParameterSpec);
            this.c.engineInit(n, key, algorithmParameterSpec, secureRandom);
        } else {
            this.a(2, n, key, algorithmParameterSpec, null, secureRandom);
        }
        this.g = true;
        this.h = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameters, SunJCE_b.b);
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.g = false;
        Cipher.a(n);
        if (this.c != null) {
            this.a(this.c, key, algorithmParameters);
            this.c.engineInit(n, key, algorithmParameters, secureRandom);
        } else {
            this.a(3, n, key, null, algorithmParameters, secureRandom);
        }
        this.g = true;
        this.h = n;
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, SunJCE_b.b);
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set<String> set;
        this.g = false;
        Cipher.a(n);
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains(i) && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && (n == 1 && blArray.length > 3 && !blArray[3] || n == 3 && blArray.length > 2 && !blArray[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        Serializable serializable2 = serializable = certificate == null ? null : certificate.getPublicKey();
        if (this.c != null) {
            this.a(this.c, (Key)serializable);
            this.c.engineInit(n, (Key)serializable, secureRandom);
        } else {
            try {
                this.a(4, n, (Key)serializable, null, null, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException);
            }
        }
        this.g = true;
        this.h = n;
    }

    private void c() {
        if (!(this instanceof NullCipher)) {
            if (!this.g) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.h != 1 && this.h != 2) {
                throw new IllegalStateException("Cipher not initialized for encryption/decryption");
            }
        }
    }

    public final byte[] update(byte[] byArray) {
        this.c();
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        this.a();
        if (byArray.length == 0) {
            return null;
        }
        return this.c.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        if (n2 == 0) {
            return null;
        }
        return this.c.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        if (n2 == 0) {
            return 0;
        }
        return this.c.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        if (n2 == 0) {
            return 0;
        }
        return this.c.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final int update(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        this.c();
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.a();
        return this.c.engineUpdate(byteBuffer, byteBuffer2);
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        this.c();
        this.a();
        return this.c.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        this.c();
        if (byArray == null || n < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        return this.c.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        this.c();
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        this.a();
        return this.c.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        return this.c.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        return this.c.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.c();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.a();
        return this.c.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final int doFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.c();
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.a();
        return this.c.engineDoFinal(byteBuffer, byteBuffer2);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (!(this instanceof NullCipher)) {
            if (!this.g) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.h != 3) {
                throw new IllegalStateException("Cipher not initialized for wrapping keys");
            }
        }
        this.a();
        return this.c.engineWrap(key);
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!(this instanceof NullCipher)) {
            if (!this.g) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.h != 4) {
                throw new IllegalStateException("Cipher not initialized for unwrapping keys");
            }
        }
        if (n != 3 && n != 2 && n != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        this.a();
        return this.c.engineUnwrap(byArray, string, n);
    }

    private AlgorithmParameterSpec a(AlgorithmParameters algorithmParameters) throws InvalidParameterSpecException {
        if (algorithmParameters == null) {
            return null;
        }
        String string = algorithmParameters.getAlgorithm().toUpperCase(Locale.ENGLISH);
        if (string.equalsIgnoreCase("RC2")) {
            return algorithmParameters.getParameterSpec(RC2ParameterSpec.class);
        }
        if (string.equalsIgnoreCase("RC5")) {
            return algorithmParameters.getParameterSpec(RC5ParameterSpec.class);
        }
        if (string.startsWith("PBE")) {
            return algorithmParameters.getParameterSpec(PBEParameterSpec.class);
        }
        if (string.startsWith("DES")) {
            return algorithmParameters.getParameterSpec(IvParameterSpec.class);
        }
        return null;
    }

    private static SunJCE_k c(String string) throws NullPointerException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException();
        }
        String[] stringArray = Cipher.a(string);
        return SunJCE_n.f.a(stringArray[0]);
    }

    public static final int getMaxAllowedKeyLength(String string) throws NoSuchAlgorithmException {
        SunJCE_k sunJCE_k = Cipher.c(string);
        return sunJCE_k.c();
    }

    public static final AlgorithmParameterSpec getMaxAllowedParameterSpec(String string) throws NoSuchAlgorithmException {
        SunJCE_k sunJCE_k = Cipher.c(string);
        return sunJCE_k.e();
    }
}

