/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls;
    public static final Log callLog;
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog;
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces;
    private transient Skeleton skel;
    private transient Map hashToMethod_Map = null;
    private static final WeakClassHashMap hashToMethod_Maps;
    private static final Map withoutSkeletons;

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    public UnicastServerRef(int n) {
        super(new LiveRef(n));
    }

    public UnicastServerRef(boolean bl) {
        this(0);
        this.forceStubUse = bl;
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(remote, object, false);
    }

    public Remote exportObject(Remote remote, Object object, boolean bl) throws RemoteException {
        Remote remote2;
        Class<? extends Object> clazz = remote.getClass();
        try {
            remote2 = Util.createProxy(clazz, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("remote object implements illegal remote interface", illegalArgumentException);
        }
        if (remote2 instanceof RemoteStub) {
            this.setSkeleton(remote);
        }
        Target target = new Target(remote, this, remote2, this.ref.getObjID(), bl);
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.getMap(clazz);
        return remote2;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = Util.createSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void dispatch(Remote var1_1, RemoteCall var2_2) throws IOException {
        try {
            var6_3 = var2_2.getInputStream();
            var3_6 = var6_3.readInt();
            if (var3_6 < 0) ** GOTO lbl10
            if (this.skel != null) {
                this.oldDispatch(var1_1, var2_2, var3_6);
                return;
            }
            try {
                throw new UnmarshalException("skeleton class not found but required for client version");
lbl10:
                // 1 sources

                var4_7 = var6_3.readLong();
            }
            catch (Exception var7_8) {
                throw new UnmarshalException("error unmarshalling call header", var7_8);
            }
            var7_9 = (MarshalInputStream)var6_3;
            var7_9.skipDefaultResolveClass();
            var8_11 = (Method)this.hashToMethod_Map.get(new Long(var4_7));
            if (var8_11 == null) {
                throw new UnmarshalException("invalid method hash");
            }
            this.logCall(var1_1, var8_11);
            var9_12 = var8_11.getParameterTypes();
            var10_13 = new Object[var9_12.length];
            try {
                this.unmarshalCustomCallData(var6_3);
                for (var11_14 = 0; var11_14 < var9_12.length; ++var11_14) {
                    var10_13[var11_14] = UnicastServerRef.unmarshalValue(var9_12[var11_14], var6_3);
                }
            }
            catch (IOException var11_15) {
                throw new UnmarshalException("error unmarshalling arguments", var11_15);
            }
            catch (ClassNotFoundException var11_16) {
                throw new UnmarshalException("error unmarshalling arguments", var11_16);
            }
            finally {
                var2_2.releaseInputStream();
            }
            try {
                var11_17 = var8_11.invoke(var1_1, var10_13);
            }
            catch (InvocationTargetException var12_19) {
                throw var12_19.getTargetException();
            }
            try {
                var12_20 = var2_2.getResultStream(true);
                var13_22 = var8_11.getReturnType();
                if (var13_22 != Void.TYPE) {
                    UnicastServerRef.marshalValue(var13_22, var11_17, var12_20);
                }
            }
            catch (IOException var12_21) {
                throw new MarshalException("error marshalling return", var12_21);
            }
        }
        catch (Throwable var6_4) {
            this.logCallException(var6_4);
            var7_10 = var2_2.getResultStream(false);
            if (var6_4 instanceof Error) {
                var6_5 /* !! */  = new ServerError("Error occurred in server thread", (Error)var6_4);
            } else if (var6_4 instanceof RemoteException) {
                var6_5 /* !! */  = new ServerException("RemoteException occurred in server thread", (Exception)var6_4);
            }
            if (UnicastServerRef.suppressStackTraces) {
                UnicastServerRef.clearStackTraces(var6_5 /* !! */ );
            }
            var7_10.writeObject(var6_5 /* !! */ );
        }
        finally {
            var2_2.releaseInputStream();
            var2_2.releaseOutputStream();
        }
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n) throws IOException {
        try {
            long l;
            ObjectInput objectInput;
            try {
                objectInput = remoteCall.getInputStream();
                l = objectInput.readLong();
            }
            catch (Exception exception) {
                throw new UnmarshalException("error unmarshalling call header", exception);
            }
            this.logCall(remote, this.skel.getOperations()[n]);
            this.unmarshalCustomCallData(objectInput);
            this.skel.dispatch(remote, remoteCall, n, l);
        }
        catch (Throwable throwable) {
            RemoteException remoteException;
            this.logCallException(throwable);
            ObjectOutput objectOutput = remoteCall.getResultStream(false);
            if (throwable instanceof Error) {
                remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
            } else if (throwable instanceof RemoteException) {
                remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(remoteException);
            }
            objectOutput.writeObject(remoteException);
        }
        finally {
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
        }
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    static {
        Boolean bl = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
        logCalls = bl;
        callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
        wantExceptionLog = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
        suppressStackTraces = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
        hashToMethod_Maps = new HashToMethod_Maps();
        withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class HashToMethod_Maps
    extends WeakClassHashMap {
        HashToMethod_Maps() {
        }

        protected Map createMap(Class clazz) {
            HashMap<Long, Method> hashMap = new HashMap<Long, Method>();
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Class[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!Remote.class.isAssignableFrom(classArray[i])) continue;
                    Method[] methodArray = classArray[i].getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        final Method method = methodArray[j];
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                method.setAccessible(true);
                                return null;
                            }
                        });
                        long l = Util.computeMethodHash(method);
                        hashMap.put(new Long(l), method);
                    }
                }
            }
            return hashMap;
        }
    }
}

