/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.util.Map;
import java.util.SortedMap;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.motif.AWTLockAccess;
import sun.awt.motif.MDataTransferer;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11SelectionHolder;

public class X11Selection {
    static FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    static Vector selections;
    long atom;
    private X11Clipboard clipboard;
    private X11SelectionHolder holder;
    private Transferable contents;
    private boolean disposed = false;
    private byte[] data = null;
    private boolean dataAvailable = false;
    private static final Object source;

    private static native void initIDs();

    static native void init();

    public X11Selection(String string, X11Clipboard x11Clipboard) {
        MDataTransferer cfr_ignored_0 = (MDataTransferer)DataTransferer.getInstance();
        this.atom = MDataTransferer.getAtomForTarget(string);
        selections.addElement(this);
        this.clipboard = x11Clipboard;
    }

    private static Object[] getSelectionsArray() {
        return selections.toArray();
    }

    native boolean pGetSelectionOwnership(Object var1, Transferable var2, long[] var3, Map var4, X11SelectionHolder var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getSelectionOwnership(Transferable transferable, X11SelectionHolder x11SelectionHolder) {
        SortedMap sortedMap = DataTransferer.getInstance().getFormatsForTransferable(transferable, DataTransferer.adaptFlavorMap(flavorMap));
        DataTransferer.getInstance();
        long[] lArray = DataTransferer.keysToLongArray(sortedMap);
        SunToolkit.insertTargetMapping(source, AppContext.getAppContext());
        AWTLockAccess.awtLock();
        try {
            boolean bl = this.pGetSelectionOwnership(source, transferable, lArray, sortedMap, x11SelectionHolder);
            if (bl) {
                this.clipboard.checkChangeHere(transferable);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            AWTLockAccess.awtUnlock();
        }
    }

    boolean isOwner() {
        return this.holder != null;
    }

    private void lostSelectionOwnership() {
        if (this.holder != null) {
            this.holder.lostSelectionOwnership();
            this.holder = null;
        }
        this.contents = null;
    }

    native void clearNativeContext();

    protected void disposeImpl() {
        selections.removeElement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11Selection x11Selection = this;
            synchronized (x11Selection) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    private static long[] getSelectionAtomsToCheckChange() {
        Object[] objectArray = X11Selection.getSelectionsArray();
        long[] lArray = new long[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            X11Clipboard x11Clipboard = ((X11Selection)objectArray[i]).clipboard;
            if (!x11Clipboard.areFlavorListenersRegistered()) continue;
            lArray[n++] = x11Clipboard.getID();
        }
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
        return lArray2;
    }

    private void checkChange(long[] lArray) {
        this.clipboard.checkChange(lArray);
    }

    static {
        source = new Object();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        selections = new Vector();
        X11Selection.initIDs();
        X11Selection.init();
    }
}

