/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.XSettings;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MChoicePeer;
import sun.awt.motif.MCustomCursor;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MDragSourceContextPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MFileDialogPeer;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MInputMethod;
import sun.awt.motif.MInputMethodDescriptor;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MMouseDragGestureRecognizer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MPopupMenuPeer;
import sun.awt.motif.MRobotPeer;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11DragSourceContextPeer;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.GetBooleanAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MToolkit
extends UNIXToolkit
implements Runnable {
    private static final DebugHelper dbg = DebugHelper.create(MToolkit.class);
    X11Clipboard clipboard;
    X11Clipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static final X11GraphicsConfig config = GraphicsEnvironment.isHeadless() ? null : (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final boolean motifdnd;
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.motif.MDataTransferer";
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";

    public MToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("MToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n = stackTraceElementArray.length - 1;
            if (n >= 0) {
                string = stackTraceElementArray[n].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            this.init(string);
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            Thread thread = new Thread(this, "AWT-Motif");
            thread.setPriority(6);
            thread.setDaemon(true);
            ThreadGroup threadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(threadGroup, new Runnable(){

                public void run() {
                    MToolkit.this.shutdown();
                }
            }, "Shutdown-Thread"));
            AWTAutoShutdown.notifyToolkitThreadBusy();
            thread.start();
        }
    }

    public native void init(String var1);

    @Override
    public native void run();

    private native void shutdown();

    @Override
    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        MToolkit.targetCreatedPeer(button, mButtonPeer);
        return mButtonPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        MToolkit.targetCreatedPeer(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        MToolkit.targetCreatedPeer(label, mLabelPeer);
        return mLabelPeer;
    }

    @Override
    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        MToolkit.targetCreatedPeer(list, mListPeer);
        return mListPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        MToolkit.targetCreatedPeer(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        MToolkit.targetCreatedPeer(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        MToolkit.targetCreatedPeer(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        MToolkit.targetCreatedPeer(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = new MChoicePeer(choice);
        MToolkit.targetCreatedPeer(choice, mChoicePeer);
        return mChoicePeer;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        MToolkit.targetCreatedPeer(frame, mFramePeer);
        return mFramePeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        MToolkit.targetCreatedPeer(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        MToolkit.targetCreatedPeer(panel, mPanelPeer);
        return mPanelPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        MToolkit.targetCreatedPeer(window, mWindowPeer);
        return mWindowPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        MToolkit.targetCreatedPeer(dialog, mDialogPeer);
        return mDialogPeer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        MToolkit.targetCreatedPeer(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        MToolkit.targetCreatedPeer(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        MToolkit.targetCreatedPeer(menu, mMenuPeer);
        return mMenuPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        MToolkit.targetCreatedPeer(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        MToolkit.targetCreatedPeer(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        MToolkit.targetCreatedPeer(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    public MEmbeddedFramePeer createEmbeddedFrame(MEmbeddedFrame mEmbeddedFrame) {
        MEmbeddedFramePeer mEmbeddedFramePeer = new MEmbeddedFramePeer(mEmbeddedFrame);
        MToolkit.targetCreatedPeer(mEmbeddedFrame, mEmbeddedFramePeer);
        return mEmbeddedFramePeer;
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        return new MFontPeer(string, n);
    }

    @Override
    public void setDynamicLayout(boolean bl) {
        dynamicLayoutSetting = bl;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupportedNative();
    }

    @Override
    public native boolean isFrameStateSupported(int var1);

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    @Override
    public native int getScreenResolution();

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected native int getScreenWidth();

    @Override
    protected native int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return super.getFontMetrics(font);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public native void beep();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        MToolkit mToolkit = this;
        synchronized (mToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new X11Clipboard("System", "CLIPBOARD");
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        MToolkit mToolkit = this;
        synchronized (mToolkit) {
            if (this.selection == null) {
                this.selection = new X11Clipboard("Selection", "PRIMARY");
            }
        }
        return this.selection;
    }

    @Override
    public boolean getLockingKeyState(int n) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n);
    }

    public native boolean getLockingKeyStateNative(int var1);

    @Override
    public native void loadSystemColors(int[] var1);

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    protected static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    protected static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        if (MToolkit.useMotifDnD()) {
            return MDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
        }
        return X11DragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return (T)new MMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new MInputMethodDescriptor();
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return MInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new MCustomCursor(image, point, string);
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) {
        return MCustomCursor.getBestCursorSize(Math.max(1, n), Math.max(1, n2));
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.lazilyLoadDynamicLayoutSupportedProperty(string);
        }
        if (!this.loadedXSettings && (string.startsWith("gnome.") || string.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                return this.desktopProperties.get(string);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl = this.isDynamicLayoutSupportedNative();
        return new Boolean(bl);
    }

    private native int getMulticlickTime();

    private native int getNumMouseButtons();

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", new Integer(this.getMulticlickTime()));
            this.desktopProperties.put("awt.mouse.numButtons", new Integer(this.getNumMouseButtons()));
        }
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new MRobotPeer(graphicsDevice.getDefaultConfiguration());
    }

    static boolean useMotifDnD() {
        return motifdnd;
    }

    private native void loadXSettings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXSettings(int n, byte[] byArray) {
        Integer n2;
        Object object;
        Map map;
        if (this.xs == null) {
            this.xs = new XSettings();
        }
        if ((map = this.xs.update(byArray)) == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry object22 : map.entrySet()) {
            object = (String)object22.getKey();
            object = "gnome." + (String)object;
            this.setDesktopProperty((String)object, object22.getValue());
        }
        Object var5_6 = null;
        object = this;
        synchronized (object) {
            n2 = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (n2 != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", n2);
        }
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    static {
        X11GraphicsEnvironment.setNativeFontPath();
        motifdnd = (Boolean)AccessController.doPrivileged(new GetBooleanAction("awt.dnd.motifdnd"));
    }
}

