/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.SystemColor;
import java.awt.peer.ComponentPeer;
import java.awt.peer.MenuComponentPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;

public abstract class XMenuComponentPeer
extends XMenuWindow
implements MenuComponentPeer {
    private XFramePeer framePeer;
    private Font font;
    Color background;
    private Color foreground;
    private Color lightShadow;
    private Color darkShadow;
    private Color select;
    private Color disabled;
    private static Field f_mParent = XToolkit.getField(MenuComponent.class, "parent");
    private static Field f_cParent = XToolkit.getField(Component.class, "parent");
    private static Field f_mPeer = XToolkit.getField(MenuComponent.class, "peer");
    private static Field f_cPeer = XToolkit.getField(Component.class, "peer");
    private static Method m_menuGetFontMethod = XToolkit.getMethod(MenuComponent.class, "getFont_NoClientCode", new Class[0]);
    private Component parentComponent;

    XMenuComponentPeer() {
    }

    XMenuComponentPeer(MenuComponent menuComponent) {
        super(menuComponent);
        this.frame = this.getFrame();
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.setBackground(this.getFrame().getBackground());
        this.setVisible(true);
    }

    MenuContainer getParent() {
        return this.getParent(this.menuTarget);
    }

    MenuContainer getParent(MenuComponent menuComponent) {
        try {
            return (MenuContainer)f_mParent.get(menuComponent);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    Component getParent(Component component) {
        try {
            return (Component)f_cParent.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    MenuComponentPeer getPeer(MenuComponent menuComponent) {
        try {
            if (menuComponent != null) {
                return (MenuComponentPeer)f_mPeer.get(menuComponent);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    ComponentPeer getPeer(Component component) {
        try {
            if (component == null) {
                return null;
            }
            return (ComponentPeer)f_cPeer.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    Font getFont() {
        Font font = this.font;
        if (font == null) {
            MenuComponent menuComponent = this.menuTarget;
            Font font2 = this.targetGetFont();
            if (font2 == null) {
                return defaultFont;
            }
            return font2;
        }
        return font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public MenuComponent getTarget() {
        return this.menuTarget;
    }

    public Graphics getGraphics() {
        if (this.getSurfaceData() == null) {
            return null;
        }
        return this.getGraphics(this.getSurfaceData(), this.getForeground(), this.getBackground(), this.getFont());
    }

    Component getParentComponent() {
        if (this.parentComponent != null) {
            return this.parentComponent;
        }
        Object object = this.menuTarget;
        while (!(object instanceof Component) && object != null) {
            if (object instanceof MenuComponent) {
                object = this.getParent((MenuComponent)object);
                continue;
            }
            if (!(object instanceof Component)) continue;
            object = this.getParent((Component)object);
        }
        this.parentComponent = (Component)object;
        return this.parentComponent;
    }

    Color getBackground() {
        Color color = null;
        Component component = this.getParentComponent();
        if (component != null) {
            color = component.getBackground();
        }
        if (color == null) {
            color = SystemColor.window;
        }
        if (this.background != color) {
            this.setBackground(color);
        }
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.surfaceData != null) {
            super.setBackground(color);
        }
        this.setColors(color);
    }

    Color getForeground() {
        return this.foreground;
    }

    Color getLightShadow() {
        return this.lightShadow;
    }

    Color getDarkShadow() {
        return this.darkShadow;
    }

    Color getSelect() {
        return this.select;
    }

    Color getDisabled() {
        return this.disabled;
    }

    void setColors(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.background = color;
        this.foreground = new Color(MotifColorUtilities.calculateForegroundFromBackground(n, n2, n3));
        this.lightShadow = new Color(MotifColorUtilities.calculateTopShadowFromBackground(n, n2, n3));
        this.darkShadow = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(n, n2, n3));
        this.select = new Color(MotifColorUtilities.calculateSelectFromBackground(n, n2, n3));
        this.disabled = color.darker();
    }

    void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        graphics.setColor(bl ? this.getLightShadow() : this.getDarkShadow());
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3, n2);
        graphics.setColor(bl ? this.getDarkShadow() : this.getLightShadow());
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4 - 1);
        graphics.setColor(color);
    }

    final Font targetGetFont() {
        try {
            MenuComponent menuComponent = this.getMenuTarget();
            if (menuComponent != null) {
                return (Font)m_menuGetFontMethod.invoke(menuComponent, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    final Object getMenuTreeLock() {
        return this.getFrame().getTreeLock();
    }

    Frame getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        Object object = this.menuTarget;
        while (!(object instanceof Frame) && object != null) {
            if (object instanceof MenuComponent) {
                object = this.getParent((MenuComponent)object);
                continue;
            }
            if (!(object instanceof Component)) continue;
            object = this.getParent((Component)object);
        }
        this.setFrame((Frame)object);
        return this.frame;
    }

    void setFrame(Frame frame) {
        this.frame = frame;
        this.framePeer = (XFramePeer)this.getPeer(frame);
    }
}

