/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.jdi.JVMTIThreadState;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class OopUtilities
implements JVMTIThreadState {
    private static IntField offsetField;
    private static IntField countField;
    private static OopField valueField;
    private static OopField threadGroupParentField;
    private static OopField threadGroupNameField;
    private static IntField threadGroupNThreadsField;
    private static OopField threadGroupThreadsField;
    private static IntField threadGroupNGroupsField;
    private static OopField threadGroupGroupsField;
    private static OopField threadNameField;
    private static OopField threadGroupField;
    private static LongField threadEETopField;
    private static IntField threadStatusField;
    private static int THREAD_STATUS_NEW;
    private static OopField hcKlassField;

    private static synchronized void initialize(TypeDataBase db) {
    }

    public static String charArrayToString(TypeArray charArray) {
        if (charArray == null) {
            return null;
        }
        return OopUtilities.charArrayToString(charArray, 0, (int)charArray.getLength());
    }

    public static String charArrayToString(TypeArray charArray, int offset, int length) {
        if (charArray == null) {
            return null;
        }
        int limit = offset + length;
        Assert.that(offset >= 0 && (long)limit <= charArray.getLength(), "out of bounds");
        StringBuffer buf = new StringBuffer(length);
        for (int i = offset; i < limit; ++i) {
            buf.append(charArray.getCharAt(i));
        }
        return buf.toString();
    }

    public static String stringOopToString(Oop stringOop) {
        if (offsetField == null) {
            InstanceKlass k = (InstanceKlass)stringOop.getKlass();
            offsetField = (IntField)k.findField("offset", "I");
            countField = (IntField)k.findField("count", "I");
            valueField = (OopField)k.findField("value", "[C");
            Assert.that(offsetField != null && countField != null && valueField != null, "must find all java.lang.String fields");
        }
        return OopUtilities.charArrayToString((TypeArray)valueField.getValue(stringOop), offsetField.getValue(stringOop), countField.getValue(stringOop));
    }

    private static void initThreadGroupFields(Oop threadGroupOop) {
        if (threadGroupParentField == null) {
            InstanceKlass k = (InstanceKlass)threadGroupOop.getKlass();
            threadGroupParentField = (OopField)k.findField("parent", "Ljava/lang/ThreadGroup;");
            threadGroupNameField = (OopField)k.findField("name", "Ljava/lang/String;");
            threadGroupNThreadsField = (IntField)k.findField("nthreads", "I");
            threadGroupThreadsField = (OopField)k.findField("threads", "[Ljava/lang/Thread;");
            threadGroupNGroupsField = (IntField)k.findField("ngroups", "I");
            threadGroupGroupsField = (OopField)k.findField("groups", "[Ljava/lang/ThreadGroup;");
            Assert.that(threadGroupParentField != null && threadGroupNameField != null && threadGroupNThreadsField != null && threadGroupThreadsField != null && threadGroupNGroupsField != null && threadGroupGroupsField != null, "must find all java.lang.ThreadGroup fields");
        }
    }

    public static Oop threadGroupOopGetParent(Oop threadGroupOop) {
        OopUtilities.initThreadGroupFields(threadGroupOop);
        return threadGroupParentField.getValue(threadGroupOop);
    }

    public static String threadGroupOopGetName(Oop threadGroupOop) {
        OopUtilities.initThreadGroupFields(threadGroupOop);
        return OopUtilities.stringOopToString(threadGroupNameField.getValue(threadGroupOop));
    }

    public static Oop[] threadGroupOopGetThreads(Oop threadGroupOop) {
        OopUtilities.initThreadGroupFields(threadGroupOop);
        int nthreads = threadGroupNThreadsField.getValue(threadGroupOop);
        Oop[] result = new Oop[nthreads];
        ObjArray threads = (ObjArray)threadGroupThreadsField.getValue(threadGroupOop);
        for (int i = 0; i < nthreads; ++i) {
            result[i] = threads.getObjAt(i);
        }
        return result;
    }

    public static Oop[] threadGroupOopGetGroups(Oop threadGroupOop) {
        OopUtilities.initThreadGroupFields(threadGroupOop);
        int ngroups = threadGroupNGroupsField.getValue(threadGroupOop);
        Oop[] result = new Oop[ngroups];
        ObjArray groups = (ObjArray)threadGroupGroupsField.getValue(threadGroupOop);
        for (int i = 0; i < ngroups; ++i) {
            result[i] = groups.getObjAt(i);
        }
        return result;
    }

    private static void initThreadFields(Oop threadOop) {
        if (threadNameField == null) {
            InstanceKlass k = (InstanceKlass)threadOop.getKlass();
            threadNameField = (OopField)k.findField("name", "[C");
            threadGroupField = (OopField)k.findField("group", "Ljava/lang/ThreadGroup;");
            threadEETopField = (LongField)k.findField("eetop", "J");
            threadStatusField = (IntField)k.findField("threadStatus", "I");
            TypeDataBase db = VM.getVM().getTypeDataBase();
            THREAD_STATUS_NEW = db.lookupIntConstant("java_lang_Thread::NEW");
            Assert.that(threadNameField != null && threadGroupField != null && threadEETopField != null, "must find all java.lang.Thread fields");
        }
    }

    public static Oop threadOopGetThreadGroup(Oop threadOop) {
        OopUtilities.initThreadFields(threadOop);
        return threadGroupField.getValue(threadOop);
    }

    public static String threadOopGetName(Oop threadOop) {
        OopUtilities.initThreadFields(threadOop);
        return OopUtilities.charArrayToString((TypeArray)threadNameField.getValue(threadOop));
    }

    public static JavaThread threadOopGetJavaThread(Oop threadOop) {
        OopUtilities.initThreadFields(threadOop);
        Address addr = threadOop.getHandle().getAddressAt(threadEETopField.getOffset());
        if (addr == null) {
            return null;
        }
        return VM.getVM().getThreads().createJavaThreadWrapper(addr);
    }

    public static int threadOopGetThreadStatus(Oop threadOop) {
        OopUtilities.initThreadFields(threadOop);
        if (threadStatusField != null) {
            return threadStatusField.getValue(threadOop);
        }
        JavaThread thr = OopUtilities.threadOopGetJavaThread(threadOop);
        if (thr == null) {
            return THREAD_STATUS_NEW;
        }
        return 1;
    }

    private static void initClassFields() {
        if (hcKlassField == null) {
            TypeDataBase db = VM.getVM().getTypeDataBase();
            int hcKlassOffset = (int)Oop.getHeaderSize();
            try {
                hcKlassOffset = (int)((long)hcKlassOffset + (long)db.lookupIntConstant("java_lang_Class::hc_klass_offset").intValue() * db.getAddressSize());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            hcKlassField = new OopField(new NamedFieldIdentifier("hc_klass"), hcKlassOffset, true);
        }
    }

    public static Klass classOopToKlass(Oop aClass) {
        OopUtilities.initClassFields();
        return (Klass)hcKlassField.getValue(aClass);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                OopUtilities.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

