/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ByteValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.PrimitiveValueImpl;

public class ByteValueImpl
extends PrimitiveValueImpl
implements ByteValue {
    private byte value;

    ByteValueImpl(VirtualMachine aVm, byte aValue) {
        super(aVm);
        this.value = aValue;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ByteValue) {
            return this.value == ((ByteValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(Object obj) {
        byte other = ((ByteValue)obj).value();
        return this.value() - other;
    }

    public Type type() {
        return this.vm.theByteType();
    }

    public byte value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public byte byteValue() {
        return this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public String toString() {
        return "" + this.value;
    }
}

