/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import java.util.List;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.OopMapCacheEntry;
import sun.jvm.hotspot.oops.CellTypeStateList;
import sun.jvm.hotspot.oops.GenerateOopMap;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

class OopMapForCacheEntry
extends GenerateOopMap {
    private OopMapCacheEntry entry;
    private int bci;
    private int stackTop;

    OopMapForCacheEntry(Method method, int bci, OopMapCacheEntry entry) {
        super(method);
        this.entry = entry;
        this.bci = bci;
        this.stackTop = -1;
    }

    public boolean reportResults() {
        return false;
    }

    public boolean possibleGCPoint(BytecodeStream bcs) {
        return false;
    }

    public void fillStackmapProlog(int nof_gc_points) {
    }

    public void fillStackmapEpilog() {
    }

    public void fillStackmapForOpcodes(BytecodeStream bcs, CellTypeStateList vars, CellTypeStateList stack, int stackTop) {
        if (bcs.bci() == this.bci) {
            this.entry.setMask(vars, stack, stackTop);
            this.stackTop = stackTop;
        }
    }

    public void fillInitVars(List initVars) {
    }

    public void computeMap() {
        Assert.that(!this.method().isNative(), "cannot compute oop map for native methods");
        if (this.method().getCodeSize() == 0L || this.method().getMaxLocals() + this.method().getMaxStack() == 0L) {
            this.entry.setEmptyMask();
        } else {
            super.computeMap();
            this.resultForBasicblock(this.bci);
        }
    }

    public int size() {
        Assert.that(this.stackTop != -1, "computeMap must be called first");
        return (int)((long)(this.method().isStatic() ? 0 : 1) + this.method().getMaxLocals() + (long)this.stackTop);
    }
}

