/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.java.security.der.DEREncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;

public class OID
implements Cloneable,
Comparable,
Serializable {
    private int[] components;
    private transient String strRep;
    private transient byte[] der;
    private boolean relative;

    public OID(int[] components) {
        this(components, false);
    }

    public OID(int[] components, boolean relative) {
        if (components == null || components.length == 0) {
            throw new IllegalArgumentException();
        }
        this.components = (int[])components.clone();
        this.relative = relative;
    }

    public OID(String strRep) {
        this(strRep, false);
    }

    public OID(String strRep, boolean relative) {
        this.relative = relative;
        this.strRep = strRep;
        this.components = OID.fromString(strRep);
    }

    public OID(InputStream derIn, int len) throws IOException {
        this(derIn, len, false);
    }

    public OID(InputStream derIn, int len, boolean relative) throws IOException {
        this.der = new byte[len];
        derIn.read(this.der);
        this.relative = relative;
        try {
            this.components = OID.fromDER(this.der, relative);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            aioobe.printStackTrace();
            throw aioobe;
        }
    }

    public OID(byte[] encoded) throws IOException {
        this(encoded, false);
    }

    public OID(byte[] encoded, boolean relative) throws IOException {
        this.der = (byte[])encoded.clone();
        this.relative = relative;
        try {
            this.components = OID.fromDER(this.der, relative);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            aioobe.printStackTrace();
            throw aioobe;
        }
    }

    private OID() {
    }

    public int[] getIDs() {
        return (int[])this.components.clone();
    }

    public byte[] getDER() {
        if (this.der == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int i = 0;
            if (!this.relative) {
                int b = this.components[i++] * 40 + (this.components.length > 1 ? this.components[i++] : 0);
                OID.encodeSubID(bout, b);
            }
            while (i < this.components.length) {
                OID.encodeSubID(bout, this.components[i]);
                ++i;
            }
            this.der = bout.toByteArray();
        }
        return (byte[])this.der.clone();
    }

    public OID getParent() {
        if (this.components.length == 1) {
            return null;
        }
        int[] parent = new int[this.components.length - 1];
        System.arraycopy(this.components, 0, parent, 0, parent.length);
        return new OID(parent);
    }

    public OID getChild(int id) {
        int[] child = new int[this.components.length + 1];
        System.arraycopy(this.components, 0, child, 0, this.components.length);
        child[child.length - 1] = id;
        return new OID(child);
    }

    public OID getRoot() {
        if (this.components.length <= 2) {
            return this;
        }
        int[] root = new int[]{this.components[0], this.components[1]};
        return new OID(root);
    }

    public boolean isRelative() {
        return this.relative;
    }

    public Object clone() {
        OID oid = new OID();
        oid.components = this.components;
        oid.strRep = this.strRep;
        return oid;
    }

    public String toString() {
        if (this.strRep != null) {
            return this.strRep;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.components.length; ++i) {
            buf.append((long)this.components[i] & 0xFFFFFFFFL);
            if (i >= this.components.length - 1) continue;
            buf.append('.');
        }
        this.strRep = buf.toString();
        return this.strRep;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.components.length; ++i) {
            ret += this.components[i] << (i & 0x1F);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return Arrays.equals(this.components, ((OID)o).components);
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int[] components2 = ((OID)o).components;
        int len = Math.min(this.components.length, components2.length);
        for (int i = 0; i < len; ++i) {
            if (this.components[i] == components2[i]) continue;
            if (this.components[i] < components2[i]) {
                return -1;
            }
            return 1;
        }
        if (this.components.length == components2.length) {
            return 0;
        }
        if (this.components.length < components2.length) {
            return -1;
        }
        return 1;
    }

    private static int[] fromDER(byte[] der, boolean relative) throws DEREncodingException {
        int j;
        int[] components = new int[der.length + 1];
        int count = 0;
        int i = 0;
        if (!relative && i < der.length) {
            j = der[i] & 0xFF;
            components[count++] = j / 40;
            components[count++] = j % 40;
            ++i;
        }
        while (i < der.length) {
            j = 0;
            do {
                j = der[i++] & 0xFF;
                int n = count;
                components[n] = components[n] << 7;
                int n2 = count;
                components[n2] = components[n2] | j & 0x7F;
                if (i < der.length || (j & 0x80) == 0) continue;
                throw new DEREncodingException("malformed OID");
            } while ((j & 0x80) != 0);
            ++count;
        }
        if (count == components.length) {
            return components;
        }
        int[] ret = new int[count];
        System.arraycopy(components, 0, ret, 0, count);
        return ret;
    }

    private static int[] fromString(String strRep) throws NumberFormatException {
        StringTokenizer tok;
        if (strRep.startsWith("OID.") || strRep.startsWith("oid.")) {
            strRep = strRep.substring(4);
        }
        if ((tok = new StringTokenizer(strRep, ".")).countTokens() == 0) {
            throw new IllegalArgumentException();
        }
        int[] components = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            components[i++] = Integer.parseInt(tok.nextToken());
        }
        return components;
    }

    private static void encodeSubID(ByteArrayOutputStream out, int id) {
        if (id < 128) {
            out.write(id);
        } else if (id < 16384) {
            out.write(id >>> 7 | 0x80);
            out.write(id & 0x7F);
        } else if (id < 0x200000) {
            out.write(id >>> 14 | 0x80);
            out.write((id >>> 7 | 0x80) & 0xFF);
            out.write(id & 0x7F);
        } else if (id < 0x10000000) {
            out.write(id >>> 21 | 0x80);
            out.write((id >>> 14 | 0x80) & 0xFF);
            out.write((id >>> 7 | 0x80) & 0xFF);
            out.write(id & 0x7F);
        }
    }
}

