import org.kde.qt.*;
import org.kde.koala.*;

/**
 *  Class KSimpleBrowser is the main application window.
 *
 *  Taken from KDE 2.0 Development book
 *
 *  Rendering HTML Files
 *
 *  A Simple Web Browser - A feature-limited Web Browser.
 *
 * @see KMainWindow
 * @see KApplication
 * @see KHTMLPart
 *
 * @author java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KSimpleBrowser extends KMainWindow {


   static final int URLLined = 1;

   KHTMLPart khtmlpart;

   public KSimpleBrowser (String name) {

      super(null,name,0);

      toolBar().insertLined( "", URLLined, SIGNAL("returnPressed()"),
               this, SLOT ("slotNewURL()"));


      toolBar().setItemAutoSized(URLLined);

      khtmlpart = new KHTMLPart(this);
      khtmlpart.begin();

      khtmlpart.write("<HTML><BODY><H1>KSimpleBrowser</H1>" +
                        "<P>To load a web page, type its URL in the line " +
                        "edit box and press enter,</P>" +
                        "</BODY></HTML>");

      khtmlpart.end();

      setCaption("KDE 2 Development book example - KSimpleBrowser");

      setCentralWidget(khtmlpart.view());

   }

   public void slotNewURL () {

      khtmlpart.openURL(new KURL(this.toolBar().getLinedText(URLLined)))   ;
   }


   static {
      qtjava.initialize();
      kdejava.initialize();
   }

}
