if [ -n "`which groff`" ]; then
	sgml2txt ./guide
fi
if [ -n "`which latex`" ]; then
	sgml2latex -o dvi ./guide
fi
if [ -n "`which dvips`" ]; then
	dvips -t letter -o ./guide.ps ./guide.dvi
	if [ -n "`which gzip`" -a -f ./guide.ps ]; then
		gzip -fN ./guide.ps
	fi
fi
sgml2info ./guide
sgml2lyx ./guide
sgml2html -I ./guide && mv -f ./guide*.html ./html
sgml2rtf ./guide && if [ ! -d ./rtf ]; then mkdir -m 755 ./rtf; fi && mv -f ./guide*.rtf ./rtf
