/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class BitString
implements Cloneable,
Comparable,
Serializable {
    private final byte[] bytes;
    private transient byte[] externBytes;
    private final int ignoredBits;
    private transient boolean[] boolVal;

    public BitString(byte[] bytes, int ignoredBits, boolean doShift) {
        this(bytes, 0, bytes.length, ignoredBits, doShift);
    }

    public BitString(byte[] bytes, int offset, int length, int ignoredBits, boolean doShift) {
        if (ignoredBits < 0 || ignoredBits > 7) {
            throw new IllegalArgumentException();
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (doShift && ignoredBits > 0) {
            this.externBytes = new byte[length];
            System.arraycopy(bytes, offset, this.externBytes, 0, length);
            this.bytes = new BigInteger(this.externBytes).shiftLeft(ignoredBits).toByteArray();
        } else {
            this.bytes = new byte[length];
            System.arraycopy(bytes, offset, this.bytes, 0, length);
        }
        this.ignoredBits = ignoredBits;
    }

    public BitString(byte[] bytes, int offset, int length, int ignoredBits) {
        this(bytes, offset, length, ignoredBits, false);
    }

    public BitString(byte[] bytes, int ignoredBits) {
        this(bytes, 0, bytes.length, ignoredBits, false);
    }

    public BitString(byte[] bytes, int offset, int length) {
        this(bytes, offset, length, 0, false);
    }

    public BitString(byte[] bytes) {
        this(bytes, 0, bytes.length, 0, false);
    }

    public byte[] toByteArray() {
        if (this.ignoredBits == 0) {
            return (byte[])this.bytes.clone();
        }
        if (this.externBytes == null) {
            this.externBytes = new BigInteger(this.bytes).shiftRight(this.ignoredBits).toByteArray();
        }
        return (byte[])this.externBytes.clone();
    }

    public byte[] getShiftedByteArray() {
        return (byte[])this.bytes.clone();
    }

    public int getIgnoredBits() {
        return this.ignoredBits;
    }

    public int size() {
        return (this.bytes.length << 3) - this.ignoredBits;
    }

    public boolean[] toBooleanArray() {
        if (this.boolVal == null) {
            this.boolVal = new boolean[this.size()];
            int j = 7;
            int k = 0;
            for (int i = 0; i < this.boolVal.length; ++i) {
                boolean bl = this.boolVal[i] = (this.bytes[k] & 1 << (j-- & 0x1F)) != 0;
                if (j >= 0) continue;
                j = 7;
                ++k;
            }
        }
        return (boolean[])this.boolVal.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cce) {
            throw new InternalError(cce.getMessage());
        }
    }

    public int compareTo(Object o) {
        BitString that = (BitString)o;
        if (this.equals(that)) {
            return 0;
        }
        if (this.bytes.length != that.bytes.length) {
            if (this.bytes.length < that.bytes.length) {
                return -1;
            }
            return 1;
        }
        if (this.ignoredBits != that.ignoredBits) {
            if (this.ignoredBits < that.ignoredBits) {
                return -1;
            }
            return 1;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == that.bytes[i]) continue;
            if (this.bytes[i] < that.bytes[i]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        BitString that = (BitString)o;
        if (this.bytes == that.bytes && this.ignoredBits == that.ignoredBits) {
            return true;
        }
        if (this.ignoredBits == that.ignoredBits) {
            return Arrays.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int j = 7;
        int k = 0;
        for (int i = 0; i < this.size(); ++i) {
            sb.append((this.bytes[k] & 1 << (j & 0x1F)) != 0 ? "1" : "0");
            if (--j >= 0) continue;
            j = 7;
            ++k;
        }
        return sb.toString();
    }
}

