/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__XFPRINT_PPRINT_PAGE_H__
#define	__XFPRINT_PPRINT_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C"
{
#endif                          /* !__cplusplus */

#define PPRINT_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_CAST(obj, pprint_page_get_type(), PprintPage)
#define PPRINT_PAGE_CLASS(klass)					\
	G_TYPE_CHECK_CLASS_CAST(klass, pprint_page_get_type(), PprintPage)
#define PPRINT_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, pprint_page_get_type())

  typedef struct _PprintPage PprintPage;
  typedef struct _PprintPageClass PprintPageClass;

  struct _PprintPage
  {
    GtkTable table;

    GtkWidget *lang;
    GtkWidget *highlight;
    GtkWidget *strip;
  };

  struct _PprintPageClass
  {
    GtkTableClass parent_class;
  };

  extern GtkType pprint_page_get_type (void);
  extern GtkWidget *pprint_page_new (void);
  extern void pprint_page_set_settings (PprintPage *, const XfprintSettingsPrettyPrint *);
  extern void pprint_page_get_settings (PprintPage *, XfprintSettingsPrettyPrint *);

#ifdef	__cplusplus
}
#endif                          /* !__cplusplus */

#endif                          /* !__XFPRINT_PPRINT_PAGE_H__ */
