/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MESSAGE_CHECK_UI_H__
#define __MESSAGE_CHECK_UI_H__

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gmime/gmime-message.h>
#include <pan/base/message-check.h>

typedef void (*MessageCheckedFunc)(Server          * server,
                                   GMimeMessage    * message,
                                   GoodnessLevel     goodness,
                                   gpointer          user_data);

void message_check_and_prompt (GtkWidget           * window,
                               Server              * server_to_post_article,
                               GMimeMessage        * message_to_post,
                               MessageCheckedFunc    checked_func,
                               gpointer              checked_func_user_data);

#endif
