/*

 $Id: dlabel.h,v 1.8 2003/10/14 21:42:32 kniederk Exp $

 KCalc 

 Copyright (C) Bernd Johannes Wuebben
               wuebben@math.cornell.edu
	       wuebben@kde.org

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */


#ifndef _D_LABEL_H_
#define _D_LABEL_H_

#include <qvaluevector.h>
#include "kcalcdisplay.h"
#include "kcalctype.h"

class CalcEngine;


class DispLogic : public KCalcDisplay
{
Q_OBJECT

public:
	DispLogic(QWidget *parent=0, const char *name=0);
	~DispLogic();

	void changeSettings();
	void EnterDigit(int data);
	bool history_next(void);
	bool history_prev(void);
	void update_from_core(CalcEngine const &core,
			      bool store_result_in_history = false);

private:
	QValueVector<CALCAMNT> _history_list;
	int _history_index;

};

#endif
