/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_openlogdialog.c - creation and destruction of the logopen dialog
 *
 * this dialog let's you select any of the supported fileformats
 * (twlog, xlog, editest, trlog (tlf), EDI, adif and cabrillo), checks
 * if a filename is selected and opens the log. If a file is already opened,
 * we jump to the page in the log.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>

#include "gui_openlogdialog.h"
#include "gui_warningdialog.h"
#include "types.h"
#include "log.h"
#include "support.h"
#include "utils.h"

extern statetype state;
extern preferencestype preferences;
extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern GList *logwindowlist;

void
on_menu_open_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *fileselection, *filemenu, *hbox, *label, *menu, *item,
		*fileselection_ok_button, *fileselection_cancel_button;
	GdkPixbuf *fileselection_icon_pixbuf;
	gchar *filen, *logn, *xlogbackupfile, *temp, *selection;
	G_CONST_RETURN gchar *sellog;
	gboolean logexist = FALSE;
	gint i, filetype, response;
	logtype *logwindow;
	LOGDB *lp;

	fileselection = gtk_file_selection_new (_("xlog - select a log"));

	/* optionmenu for the file types to be opened */
	hbox = gtk_hbox_new (FALSE, 50);
	gtk_container_add (GTK_CONTAINER (GTK_FILE_SELECTION (fileselection)->main_vbox), hbox);
	label = gtk_label_new (_("Type of log:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	filemenu = gtk_option_menu_new ();
	gtk_widget_ref (filemenu);
	g_object_set_data_full (G_OBJECT (fileselection), "filemenu", filemenu,	(GDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (hbox), filemenu, FALSE, FALSE, 0);
	menu = gtk_menu_new ();

	/* Keep entries in same order as enum log_file_type in logfile/logfile.h */
	item = gtk_menu_item_new_with_label ("xlog");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("twlog");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("adif");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("cabrillo");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("editest");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("trlog");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	item = gtk_menu_item_new_with_label ("EDI");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (filemenu), menu);
	gtk_option_menu_set_history (GTK_OPTION_MENU (filemenu), 0);
	gtk_widget_show_all (hbox);

	gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
	gtk_window_set_position (GTK_WINDOW (fileselection), GTK_WIN_POS_MOUSE);
	fileselection_icon_pixbuf = create_pixbuf ("xlog.png");
	if (fileselection_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (fileselection), fileselection_icon_pixbuf);
			g_object_unref (fileselection_icon_pixbuf);
		}

	fileselection_ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
	gtk_widget_show (fileselection_ok_button);
	GTK_WIDGET_SET_FLAGS (fileselection_ok_button, GTK_CAN_DEFAULT);

	fileselection_cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
	gtk_widget_show (fileselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (fileselection_cancel_button, GTK_CAN_DEFAULT);

	selection = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, NULL);
	gtk_file_selection_set_filename (GTK_FILE_SELECTION (fileselection), selection);
	g_free (selection);

	response = gtk_dialog_run (GTK_DIALOG(fileselection));
	state.utf8error = FALSE;
	if (response == GTK_RESPONSE_OK)
	{
		/* skip all if nothing filled in */
		if (strlen (gtk_editable_get_chars (GTK_EDITABLE(GTK_FILE_SELECTION(fileselection)->selection_entry), 0, -1)) > 0)
		{
			menu = GTK_OPTION_MENU (filemenu)->menu;
			item = gtk_menu_get_active (GTK_MENU (menu));
			/* skip old log format (0) */
			filetype = g_list_index (GTK_MENU_SHELL (menu)->children, item) + 1;

			/* don't free sellog */
			sellog = gtk_file_selection_get_filename(GTK_FILE_SELECTION (fileselection));
			filen = g_path_get_basename (sellog);
			logn = logname (filen);
			g_free (filen);

			/* unselect any selected QSO */
			for (i = 0; i < g_list_length (logwindowlist); i++)
			{
				logwindow = g_list_nth_data (logwindowlist, i);
				gtk_tree_selection_unselect_all(gtk_tree_view_get_selection(GTK_TREE_VIEW (logwindow->treeview)));
			}

			/* if log exist jump to the page in the notebook */
			for (i = 0; i < g_list_length (logwindowlist); i++)
			{
				logwindow = g_list_nth_data (logwindowlist, i);
				if (g_ascii_strcasecmp (logn, logwindow->logname) == 0)
				{
					gtk_notebook_set_current_page (GTK_NOTEBOOK(mainnotebook), i);
					set_qsoframe (logwindow);
					logexist = TRUE;
					break;
				}
			}
			if (!logexist)
			{
				state.qsos = 0;
				lp = log_file_open (sellog, filetype);
				if (lp)
				{
					logwindow =	openlog (lp, logn, state.logwindows++);
					log_file_qso_foreach (lp, fillin_list, logwindow);
					log_file_close (lp);
					lp->type = filetype;
					if ((lp->type) == TYPE_FLOG)
					{
						xlogbackupfile = g_strconcat (sellog, ".backup", NULL);
						unlink (xlogbackupfile);
						backuplog ((gchar *) sellog, xlogbackupfile);
						g_free (xlogbackupfile);
					}
					logwindowlist =	g_list_append (logwindowlist, logwindow);
					gtk_notebook_set_current_page (GTK_NOTEBOOK(mainnotebook), state.logwindows - 1);
					set_qsoframe (logwindow);
					temp = g_strdup_printf (_("%d QSO's loaded"), state.qsos);
					update_statusbar (temp);
					g_free (temp);
				}
			}
			g_free (logn);
		}
		else
		{
			temp = g_strdup_printf (_("No filename entered, open cancelled"));
			update_statusbar (temp);
			g_free (temp);
		}
	}

	gtk_widget_destroy (fileselection);
	while (gtk_events_pending ()) gtk_main_iteration ();
	if (state.utf8error) 
		warningdialog (_("xlog - open log"), 
			_("There were some errors converting from your locale to UTF8, "
			"which is used by GTK+ internally. It is best if you start xlog "
			"from a terminal and see what the errors are. Please check your "
			"language settings and your log fields!"));
}
