/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontRunIterator;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.ScriptRun;
import sun.font.StandardGlyphVector;
import sun.font.SunLayoutEngine;
import sun.font.TextRecord;

public final class GlyphLayout {
    private GVData _gvdata = new GVData();
    private static GlyphLayout cache;
    private LayoutEngineFactory _lef;
    private TextRecord _textRecord = new TextRecord();
    private ScriptRun _scriptRuns = new ScriptRun();
    private FontRunIterator _fontRuns = new FontRunIterator();
    private int _ercount;
    private ArrayList _erecords = new ArrayList(10);
    private Point2D.Float _pt = new Point2D.Float();
    private FontStrikeDesc _sd = new FontStrikeDesc();
    private float[] _mat = new float[4];
    private boolean _rtl;
    private int _offset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphLayout get(LayoutEngineFactory layoutEngineFactory) {
        if (layoutEngineFactory == null) {
            layoutEngineFactory = SunLayoutEngine.instance();
        }
        GlyphLayout glyphLayout = null;
        Class<GlyphLayout> clazz = GlyphLayout.class;
        synchronized (GlyphLayout.class) {
            if (cache != null) {
                glyphLayout = cache;
                cache = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (glyphLayout == null) {
                glyphLayout = new GlyphLayout();
            }
            glyphLayout._lef = layoutEngineFactory;
            return glyphLayout;
        }
    }

    public static void done(GlyphLayout glyphLayout) {
        glyphLayout._lef = null;
        cache = glyphLayout;
    }

    public StandardGlyphVector layout(Font font, FontRenderContext fontRenderContext, char[] cArray, int n2, int n3, int n4, StandardGlyphVector standardGlyphVector) {
        int n5;
        int n6;
        if (cArray == null || n2 < 0 || n3 < 0 || n3 > cArray.length - n2) {
            throw new IllegalArgumentException();
        }
        this.init(n3);
        this._offset = n2;
        SDCache sDCache = SDCache.get(font, fontRenderContext);
        this._mat[0] = (float)sDCache.gtx.getScaleX();
        this._mat[1] = (float)sDCache.gtx.getShearY();
        this._mat[2] = (float)sDCache.gtx.getShearX();
        this._mat[3] = (float)sDCache.gtx.getScaleY();
        this._pt.setLocation(sDCache.delta);
        int n7 = n2 + n3;
        int n8 = 0;
        int n9 = cArray.length;
        if (n4 != 0) {
            if ((n4 & 1) != 0) {
                this._rtl = true;
            }
            if ((n4 & 2) != 0) {
                n8 = n2;
            }
            if ((n4 & 4) != 0) {
                n9 = n7;
            }
        }
        int n10 = -1;
        Font2D font2D = FontManager.getFont2D(font);
        this._textRecord.init(cArray, n2, n7, n8, n9);
        int n11 = n2;
        if (font2D instanceof CompositeFont) {
            this._scriptRuns.init(cArray, n2, n3);
            this._fontRuns.init((CompositeFont)font2D, cArray, n2, n7);
            while (this._scriptRuns.next()) {
                n6 = this._scriptRuns.getScriptLimit();
                n5 = this._scriptRuns.getScriptCode();
                while (this._fontRuns.next(n5, n6)) {
                    PhysicalFont physicalFont = this._fontRuns.getFont();
                    if (physicalFont instanceof NativeFont) {
                        physicalFont = ((NativeFont)physicalFont).getDelegateFont();
                    }
                    int n12 = this._fontRuns.getGlyphMask();
                    int n13 = this._fontRuns.getPos();
                    this.nextEngineRecord(n11, n13, n5, n10, physicalFont, n12);
                    n11 = n13;
                }
            }
        } else {
            this._scriptRuns.init(cArray, n2, n3);
            while (this._scriptRuns.next()) {
                n6 = this._scriptRuns.getScriptLimit();
                n5 = this._scriptRuns.getScriptCode();
                this.nextEngineRecord(n11, n6, n5, n10, font2D, 0);
                n11 = n6;
            }
        }
        n6 = 0;
        n5 = this._ercount;
        int n14 = 1;
        if (this._rtl) {
            n6 = n5 - 1;
            n5 = -1;
            n14 = -1;
        }
        this._sd = sDCache.sd;
        while (n6 != n5) {
            EngineRecord engineRecord = (EngineRecord)this._erecords.get(n6);
            while (true) {
                try {
                    engineRecord.layout();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this._gvdata.grow();
                    continue;
                }
                break;
            }
            n6 += n14;
        }
        StandardGlyphVector standardGlyphVector2 = this._gvdata.createGlyphVector(font, fontRenderContext, standardGlyphVector);
        return standardGlyphVector2;
    }

    private GlyphLayout() {
    }

    private void init(int n2) {
        this._rtl = false;
        this._ercount = 0;
        this._gvdata.init(n2);
    }

    private void nextEngineRecord(int n2, int n3, int n4, int n5, Font2D font2D, int n6) {
        EngineRecord engineRecord = null;
        if (this._ercount == this._erecords.size()) {
            engineRecord = new EngineRecord();
            this._erecords.add(engineRecord);
        } else {
            engineRecord = (EngineRecord)this._erecords.get(this._ercount);
        }
        engineRecord.init(n2, n3, font2D, n4, n5, n6);
        ++this._ercount;
    }

    private final class EngineRecord {
        private int start;
        private int limit;
        private int gmask;
        private LayoutEngineKey key = new LayoutEngineKey();
        private LayoutEngine engine;

        EngineRecord() {
        }

        void init(int n2, int n3, Font2D font2D, int n4, int n5, int n6) {
            this.start = n2;
            this.limit = n3;
            this.gmask = n6;
            this.key.init(font2D, n4, n5);
            this.engine = GlyphLayout.this._lef.getEngine(this.key);
        }

        void layout() {
            ((GlyphLayout)GlyphLayout.this)._textRecord.start = this.start;
            ((GlyphLayout)GlyphLayout.this)._textRecord.limit = this.limit;
            this.engine.layout(GlyphLayout.this._sd, GlyphLayout.this._mat, this.gmask, this.start - GlyphLayout.this._offset, GlyphLayout.this._textRecord, GlyphLayout.this._rtl, GlyphLayout.this._pt, GlyphLayout.this._gvdata);
        }
    }

    public static final class GVData {
        public int _count;
        public int _flags;
        public int[] _glyphs;
        public float[] _positions;
        public int[] _indices;
        private static final int UNINITIALIZED_FLAGS = -1;

        public void init(int n2) {
            this._count = 0;
            this._flags = -1;
            if (this._glyphs == null || this._glyphs.length < n2) {
                if (n2 < 20) {
                    n2 = 20;
                }
                this._glyphs = new int[n2];
                this._positions = new float[n2 * 2 + 2];
                this._indices = new int[n2];
            }
        }

        public void grow() {
            this.grow(this._glyphs.length / 4);
        }

        public void grow(int n2) {
            int n3 = this._glyphs.length + n2;
            int[] nArray = new int[n3];
            System.arraycopy(this._glyphs, 0, nArray, 0, this._count);
            this._glyphs = nArray;
            float[] fArray = new float[n3 * 2 + 2];
            System.arraycopy(this._positions, 0, fArray, 0, this._count * 2 + 2);
            this._positions = fArray;
            int[] nArray2 = new int[n3];
            System.arraycopy(this._indices, 0, nArray2, 0, this._count);
            this._indices = nArray2;
        }

        public void adjustPositions(AffineTransform affineTransform) {
            affineTransform.transform(this._positions, 0, this._positions, 0, this._count);
        }

        public StandardGlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, StandardGlyphVector standardGlyphVector) {
            if (this._flags == -1) {
                this._flags = 0;
                if (this._count > 1) {
                    boolean bl2 = true;
                    boolean bl3 = true;
                    int n2 = this._count;
                    for (int i2 = 0; i2 < this._count && (bl2 || bl3); ++i2) {
                        int n3 = this._indices[i2];
                        bl2 = bl2 && n3 == i2;
                        bl3 = bl3 && n3 == --n2;
                    }
                    if (bl3) {
                        this._flags |= 4;
                    }
                    if (!bl3 && !bl2) {
                        this._flags |= 8;
                    }
                }
                this._flags |= 2;
            }
            int[] nArray = new int[this._count];
            System.arraycopy(this._glyphs, 0, nArray, 0, this._count);
            float[] fArray = null;
            if ((this._flags & 2) != 0) {
                fArray = new float[this._count * 2 + 2];
                System.arraycopy(this._positions, 0, fArray, 0, fArray.length);
            }
            int[] nArray2 = null;
            if ((this._flags & 8) != 0) {
                nArray2 = new int[this._count];
                System.arraycopy(this._indices, 0, nArray2, 0, this._count);
            }
            if (standardGlyphVector == null) {
                standardGlyphVector = new StandardGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, this._flags);
            } else {
                standardGlyphVector.initGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, this._flags);
            }
            return standardGlyphVector;
        }
    }

    public static interface LayoutEngine {
        public void layout(FontStrikeDesc var1, float[] var2, int var3, int var4, TextRecord var5, boolean var6, Point2D.Float var7, GVData var8);
    }

    public static interface LayoutEngineFactory {
        public LayoutEngine getEngine(Font2D var1, int var2, int var3);

        public LayoutEngine getEngine(LayoutEngineKey var1);
    }

    public static final class LayoutEngineKey {
        private Font2D font;
        private int script;
        private int lang;

        LayoutEngineKey() {
        }

        LayoutEngineKey(Font2D font2D, int n2, int n3) {
            this.init(font2D, n2, n3);
        }

        void init(Font2D font2D, int n2, int n3) {
            this.font = font2D;
            this.script = n2;
            this.lang = n3;
        }

        LayoutEngineKey copy() {
            return new LayoutEngineKey(this.font, this.script, this.lang);
        }

        Font2D font() {
            return this.font;
        }

        int script() {
            return this.script;
        }

        int lang() {
            return this.lang;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            try {
                LayoutEngineKey layoutEngineKey = (LayoutEngineKey)object;
                return this.script == layoutEngineKey.script && this.lang == layoutEngineKey.lang && this.font.equals(layoutEngineKey.font);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.script ^ this.lang ^ this.font.hashCode();
        }
    }

    private static final class SDCache {
        public Font key_font;
        public FontRenderContext key_frc;
        public AffineTransform dtx;
        public AffineTransform invdtx;
        public AffineTransform gtx;
        public Point2D.Float delta;
        public FontStrikeDesc sd;
        private static final Point2D.Float ZERO_DELTA = new Point2D.Float();
        private static HashMap cache = new HashMap(10);

        private SDCache(Font font, FontRenderContext fontRenderContext) {
            this.key_font = font;
            this.key_frc = fontRenderContext;
            this.dtx = fontRenderContext.getTransform();
            this.dtx.setTransform(this.dtx.getScaleX(), this.dtx.getShearY(), this.dtx.getShearX(), this.dtx.getScaleY(), 0.0, 0.0);
            if (!this.dtx.isIdentity()) {
                try {
                    this.invdtx = this.dtx.createInverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw new InternalError();
                }
            }
            float f2 = font.getSize2D();
            if (font.isTransformed()) {
                this.gtx = font.getTransform();
                this.gtx.scale(f2, f2);
                this.delta = new Point2D.Float((float)this.gtx.getTranslateX(), (float)this.gtx.getTranslateY());
                this.gtx.setTransform(this.gtx.getScaleX(), this.gtx.getShearY(), this.gtx.getShearX(), this.gtx.getScaleY(), 0.0, 0.0);
                this.gtx.preConcatenate(this.dtx);
            } else {
                this.delta = ZERO_DELTA;
                this.gtx = new AffineTransform(this.dtx);
                this.gtx.scale(f2, f2);
            }
            this.sd = new FontStrikeDesc(this.dtx, this.gtx, font.getStyle(), fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics());
        }

        public static SDCache get(Font font, FontRenderContext fontRenderContext) {
            SDKey sDKey = new SDKey(font, fontRenderContext);
            SDCache sDCache = (SDCache)cache.get(sDKey);
            if (sDCache == null) {
                sDCache = new SDCache(font, fontRenderContext);
                cache.put(sDKey, sDCache);
            }
            return sDCache;
        }

        private static final class SDKey {
            private final Font font;
            private final FontRenderContext frc;
            private final int hash;

            SDKey(Font font, FontRenderContext fontRenderContext) {
                this.font = font;
                this.frc = fontRenderContext;
                this.hash = font.hashCode() ^ fontRenderContext.hashCode();
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object object) {
                try {
                    SDKey sDKey = (SDKey)object;
                    return !(this.hash != sDKey.hash || this.font != sDKey.font && !this.font.equals(sDKey.font) || this.frc != sDKey.frc && !this.frc.equals(sDKey.frc));
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        }
    }
}

