/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.EncodingInfo;
import com.sun.org.apache.xml.internal.serializer.ObjectFactory;
import com.sun.org.apache.xml.internal.serializer.SecuritySupport;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class Encodings {
    static final int m_defaultLastPrintable = 127;
    static final String ENCODINGS_FILE = "com/sun/org/apache/xml/internal/serializer/Encodings.properties";
    static final String ENCODINGS_PROP = "com.sun.org.apache.xalan.internal.serialize.encodings";
    private static final Method SUN_CHAR2BYTE_CONVERTER_METHOD = Encodings.findCharToByteConverterMethod();
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    private static Method findCharToByteConverterMethod() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.io.CharToByteConverter");
                        Class[] classArray = new Class[]{String.class};
                        return clazz.getMethod("getConverter", classArray);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                }
            });
        }
        catch (Exception exception) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
        }
        return null;
    }

    public static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        for (int i2 = 0; i2 < _encodings.length; ++i2) {
            if (!Encodings._encodings[i2].name.equalsIgnoreCase(string)) continue;
            try {
                return new OutputStreamWriter(outputStream, Encodings._encodings[i2].javaName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new OutputStreamWriter(outputStream, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static Object getCharToByteConverter(String string) {
        if (SUN_CHAR2BYTE_CONVERTER_METHOD == null) {
            return null;
        }
        Object[] objectArray = new Object[1];
        for (int i2 = 0; i2 < _encodings.length; ++i2) {
            if (!Encodings._encodings[i2].name.equalsIgnoreCase(string)) continue;
            try {
                objectArray[0] = Encodings._encodings[i2].javaName;
                Object object = SUN_CHAR2BYTE_CONVERTER_METHOD.invoke(null, objectArray);
                if (null == object) continue;
                return object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getLastPrintable(String string) {
        String string2 = string.toUpperCase();
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        if (encodingInfo != null) {
            return encodingInfo.lastPrintable;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = System.getProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    public static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string.toUpperCase());
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        for (int i2 = 0; i2 < _encodings.length; ++i2) {
            if (!Encodings._encodings[i2].name.equalsIgnoreCase(string)) continue;
            return Encodings._encodings[i2].javaName;
        }
        return string;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL uRL = null;
        try {
            Object object;
            String string = null;
            InputStream inputStream = null;
            try {
                string = System.getProperty(ENCODINGS_PROP, "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                object = SecuritySupport.getInstance();
                inputStream = ((SecuritySupport)object).getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            }
            object = new Properties();
            if (inputStream != null) {
                ((Properties)object).load(inputStream);
                inputStream.close();
            }
            int n2 = ((Hashtable)object).size();
            int n3 = 0;
            Enumeration enumeration = ((Hashtable)object).keys();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = (String)enumeration.nextElement();
                String string3 = ((Properties)object).getProperty(string2);
                ++n3;
                int n4 = string3.indexOf(32);
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (string3.charAt(i3) != ',') continue;
                    ++n3;
                }
            }
            EncodingInfo[] encodingInfoArray = new EncodingInfo[n3];
            int n5 = 0;
            enumeration = ((Hashtable)object).keys();
            for (int i4 = 0; i4 < n2; ++i4) {
                int n6;
                String string4;
                String string5 = (String)enumeration.nextElement();
                String string6 = ((Properties)object).getProperty(string5);
                int n7 = string6.indexOf(32);
                if (n7 < 0) {
                    string4 = string6;
                    n6 = 255;
                    continue;
                }
                n6 = Integer.decode(string6.substring(n7).trim());
                StringTokenizer stringTokenizer = new StringTokenizer(string6.substring(0, n7), ",");
                boolean bl2 = true;
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    encodingInfoArray[n5] = new EncodingInfo(string4, string5, n6);
                    _encodingTableKeyMime.put(string4.toUpperCase(), encodingInfoArray[n5]);
                    if (bl2) {
                        _encodingTableKeyJava.put(string5.toUpperCase(), encodingInfoArray[n5]);
                    }
                    ++n5;
                    bl2 = false;
                }
            }
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }
}

