/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final int byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    UTF_16Encoder(Charset cs, int byteOrder, boolean useByteOrderMark) {
        byte[] byArray;
        float f = useByteOrderMark ? 4.0f : 2.0f;
        if (byteOrder == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(cs, 2.0f, f, byArray);
        this.byteOrder = byteOrder;
        this.useByteOrderMark = useByteOrderMark;
        this.needsByteOrderMark = useByteOrderMark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        CoderResult coderResult;
        int inPos;
        block14: {
            CoderResult coderResult2;
            block13: {
                CoderResult coderResult3;
                block12: {
                    CoderResult coderResult4;
                    block11: {
                        if (this.needsByteOrderMark) {
                            if (out.remaining() < 2) {
                                return CoderResult.OVERFLOW;
                            }
                            this.put(out, '\ufeff');
                            this.needsByteOrderMark = false;
                        }
                        inPos = in.position();
                        try {
                            while (in.hasRemaining()) {
                                char c = in.get();
                                if ('\ud800' <= c && c <= '\udfff') {
                                    if (c > '\udbff') {
                                        CoderResult coderResult5 = CoderResult.malformedForLength(1);
                                        Object var7_11 = null;
                                        in.position(inPos);
                                        return coderResult5;
                                    }
                                    if (in.remaining() < 1) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        break block11;
                                    }
                                    char d = in.get();
                                    if (d < '\udc00' || d > '\udfff') {
                                        coderResult3 = CoderResult.malformedForLength(1);
                                        break block12;
                                    } else {
                                        this.put(out, c);
                                        this.put(out, d);
                                        inPos += 2;
                                        continue;
                                    }
                                }
                                if (out.remaining() < 2) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block13;
                                }
                                this.put(out, c);
                                ++inPos;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var7_16 = null;
                            in.position(inPos);
                            throw throwable;
                        }
                    }
                    Object var7_12 = null;
                    in.position(inPos);
                    return coderResult4;
                }
                Object var7_13 = null;
                in.position(inPos);
                return coderResult3;
            }
            Object var7_14 = null;
            in.position(inPos);
            return coderResult2;
        }
        Object var7_15 = null;
        in.position(inPos);
        return coderResult;
    }

    private void put(ByteBuffer out, char c) {
        if (this.byteOrder == 0) {
            out.put((byte)(c >> 8));
            out.put((byte)c);
        } else {
            out.put((byte)c);
            out.put((byte)(c >> 8));
        }
    }

    protected void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }
}

