/*  gxfce
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifndef __XINERAMA_H__
#define __XINERAMA_H__

/* Define EMULATE_XINERAMA to emulate Xinerama on a systems without Xinerama
 * native support. For DEBUG purpose ONLY !
 */
#undef EMULATE_XINERAMA

#ifdef EMULATE_XINERAMA
#ifndef HAVE_LIBXINERAMA
/* Define XineramaScreenInfo for systems missing Xinerama support */
typedef struct
{
    int screen_number;
    short x_org;
    short y_org;
    short width;
    short height;
}
XineramaScreenInfo;
#endif
#endif

gboolean xineramaInit (Display * dpy);
void xineramaFree (void);

int xineramaGetHeads (void);
int MyDisplayFullHeight (Display * dpy, int screen);
int MyDisplayFullWidth (Display * dpy, int screen);
int MyDisplayHeight (Display * dpy, int screen, int x, int y);
int MyDisplayWidth (Display * dpy, int screen, int x, int y);
int MyDisplayX (int x, int y);
int MyDisplayY (int x, int y);
int MyDisplayMaxX (Display * dpy, int screen, int x, int y);
int MyDisplayMaxY (Display * dpy, int screen, int x, int y);
gboolean isRightMostHead (Display * dpy, int screen, int x, int y);
gboolean isLeftMostHead (Display * dpy, int screen, int x, int y);
gboolean isTopMostHead (Display * dpy, int screen, int x, int y);
gboolean isBottomMostHead (Display * dpy, int screen, int x, int y);

#endif
