
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>
#include <fcntl.h>

#define SOCKET_FILENAME "%s/.gxine/socket"
#define BUF_LEN 1024

int main (int argc, char **argv) {

  int                fd;
  struct sockaddr_un cli_adr, serv_adr;
  int                length = sizeof(struct sockaddr_un);
  char               filename [1024];
  char              *tstr;

  /* server filename */
  snprintf (filename, 1024, SOCKET_FILENAME, getenv ("HOME")); 

  printf ("connecting to %s...\n", filename);

  fd = socket (AF_UNIX, SOCK_STREAM, 0);

  /* initialize the client address structure */
  memset (&cli_adr, 0, sizeof (cli_adr));
  cli_adr.sun_family = AF_UNIX;
  tstr = tmpnam (NULL);
  strcpy (cli_adr.sun_path, tstr);
  
  unlink (tstr);

  /* bind the socket to the client's address */
  if (bind (fd, (struct sockaddr*) &cli_adr, length) < 0) {
    perror ("bind");
    exit (EXIT_FAILURE);
  }

  /* initialize the server address structure */
  memset(&serv_adr, 0, sizeof(serv_adr));
  serv_adr.sun_family = AF_UNIX;
  strcpy (serv_adr.sun_path, filename);

  if (connect (fd, (struct sockaddr *) &serv_adr, sizeof (serv_adr)) < 0) {
    perror ("connect");
    exit (EXIT_FAILURE);
  }
  
  printf ("connected.\n");

  if (argc>1) {

    /* noninteractive */

    printf ("sending command\n");

    write (fd, argv[1], strlen(argv[1]));
    write (fd, "\n", 1);

    printf ("done.\n");

  } else {
    /* interactive mode */
    int    n;

    if (fd>STDIN_FILENO)
      n=fd+1;
    else
      n=STDIN_FILENO+1;

    while (1) {

      char buf[10];
      fd_set rset;

      FD_ZERO (&rset);
      FD_SET  (fd, &rset);
      FD_SET  (STDIN_FILENO, &rset);

      if (select (n, &rset, NULL, NULL, NULL) <= 0) {
	perror ("client: select: ");
	return -1;
      }

      if (FD_ISSET (fd, &rset)) {
	if (read (fd, buf, 1)==1)
	  write (STDOUT_FILENO, buf, 1);
      }

      if (FD_ISSET (STDIN_FILENO, &rset)) {
	if (read (STDIN_FILENO, buf, 1)==1)
	  write (fd, buf, 1);
      }
    }
  }

  close(fd);

  unlink (tstr);

  return 0;
}
