/***************************************************************************
                          strength.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include "strength.h"
#include "stuff.h"
#include "asusled.h"

extern deviceinfo *information;

Strength::Strength (QWidget * parent)
    :QWidget (parent, "strength")
{
  KStandardDirs finder;
  kdedir = finder.findResourceDir ("data", "kwifimanager/pics/no_card.png");
  kdedir += "kwifimanager/pics/";
  NOT_CON_OFFLINE_ADHOC = new QPixmap (kdedir + "offline.png");
  EXCELLENT = new QPixmap (kdedir + "excellent.png");
  GOOD = new QPixmap (kdedir + "good.png");
  MARGINAL = new QPixmap (kdedir + "marginal.png");
  OOR_MINIMUM = new QPixmap (kdedir + "oor_minimum.png");
  OOR_DOWN = new QPixmap (kdedir + "oor_down.png");
  led = new Led();
}

Strength::~Strength ()
{
    delete led;
    delete NOT_CON_OFFLINE_ADHOC;
    delete GOOD;
    delete MARGINAL;
    delete OOR_MINIMUM;
    delete OOR_DOWN;
}

void 
Strength::paintEvent (QPaintEvent * event)
{
  updateInfo ( event );
}

void
Strength::updateInfo (QPaintEvent *)
{
  QPainter *strengthpainter = new QPainter (this);
  sstrength1 = "%1";
  int tempstrength = information->qual.qual;
  if
((information->mode==2)&&(information->has_range==1)&&(information->range.max_qual.qual!=0))
    tempstrength = (int) tempstrength *92 / (int) information->range.max_qual.qual;
  sstrength2 = "%1";
  if (information->has_freq != 1)
    {
      sstrength1 = sstrength1.arg (i18n ("NOT CONNECTED"));
      sstrength2 = sstrength2.arg(i18n("N/A"));
      strengthpainter->drawPixmap (50, 20, *NOT_CON_OFFLINE_ADHOC);
      emit strengthChanged(NOT_CON_OFFLINE_ADHOC,sstrength2);
      if (led->state==true) led->Off();
    }
  else if (information->mode == 1)
    {
      sstrength1 = sstrength1.arg (i18n ("AD-HOC MODE"));
      sstrength2 = sstrength2.arg(i18n("N/A"));
      strengthpainter->drawPixmap (50, 20, *NOT_CON_OFFLINE_ADHOC);
      emit strengthChanged(NOT_CON_OFFLINE_ADHOC,sstrength2);
      if (led->state==true) led->Off();
    }
  else if (tempstrength > 45)
    {
      sstrength1 = sstrength1.arg (i18n ("ULTIMATE"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *EXCELLENT);
      emit strengthChanged(EXCELLENT,sstrength2);
      if (led->state==false) led->On();
    }
  else if (tempstrength > 35)
    {
      sstrength1 = sstrength1.arg (i18n ("TOP"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *EXCELLENT);
      emit strengthChanged(EXCELLENT,sstrength2);
      if (led->state==false) led->On();
    }
  else if (tempstrength > 25)
    {
      sstrength1 = sstrength1.arg (i18n ("EXCELLENT"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *EXCELLENT);
      emit strengthChanged(EXCELLENT,sstrength2);
      if (led->state==false) led->On();
    }
  else if (tempstrength > 15)
    {
      sstrength1 = sstrength1.arg (i18n ("GOOD"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *GOOD);
      emit strengthChanged(GOOD,sstrength2);
      if (led->state==false) led->On();
    }
  else if (tempstrength > 5)
    {
      sstrength1 = sstrength1.arg (i18n ("WEAK"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *MARGINAL);
      emit strengthChanged(MARGINAL,sstrength2);
      if (led->state==false) led->On();
    }
  else if (tempstrength > 0)
    {
      sstrength1 = sstrength1.arg (i18n ("MINIMUM"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *OOR_MINIMUM);
      emit strengthChanged(OOR_MINIMUM,sstrength2);
      if (led->state==true) led->Off();
    }
  else if ((tempstrength == 0) && (information->mode == 2))
    {
      sstrength1 = sstrength1.arg (i18n ("OUT OF RANGE"));
      sstrength2 = sstrength2.arg(tempstrength);
      strengthpainter->drawPixmap (50, 20, *OOR_DOWN);
      emit strengthChanged(OOR_DOWN,sstrength2);
      if (led->state==true) led->Off();
    }
  else
    {
      sstrength1 = sstrength1.arg (i18n ("N/A"));
      sstrength2 = sstrength2.arg("N/A");
      strengthpainter->drawPixmap (50, 20, *NOT_CON_OFFLINE_ADHOC);
      emit strengthChanged(NOT_CON_OFFLINE_ADHOC,sstrength2);
      if (led->state==true) led->Off();
    };
  sstrength2 = i18n("Signal strength: ")+sstrength2;
  strengthpainter->drawText (5, 70, sstrength1);
  strengthpainter->drawText (5, 90, sstrength2);
  delete strengthpainter;
}

#include "strength.moc"
