<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann
  ** Date: Thu Sep 12 18:57:21 CEST 2002 @831 /Internet Time/
  ** Purpose:
  ** Changed:
  **
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:func="http://exslt.org/functions"
    xmlns:str="http://exslt.org/strings"
    xmlns:kde="http://kde.org/functions"
    extension-element-prefixes="func"
>
    <!-- Function: kde:if
      ** @param bool
      ** @param trueVal
      ** @param falseVal
      ** @return ( bool ) ? trueVal : falseVal
      -->
    <func:function name="kde:if">
        <xsl:param name="bool"/>
        <xsl:param name="trueVal"/>
        <xsl:param name="falseVal"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$bool"><xsl:value-of select="$trueVal"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$falseVal"/></xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>

    <!-- Function: kde:index
      ** @param string
      ** @param substring
      ** @return the index of "substring" in "string"
      -->
    <func:function name="kde:index">
        <xsl:param name="string"/>
        <xsl:param name="substring"/>
        <func:result select="string-length(substring-before($string, $substring))"/> 
    </func:function>
    
    <!--
      ** Function: replace
      ** @param string, string to search
      ** @param lookup, string to look up
      ** @param replace, string to substitute
      ** @return $string with all occurences of $lookup replaced by $replace 
      -->
    <func:function name="kde:replace">
        <xsl:param name="string"/>
        <xsl:param name="lookup"/>
        <xsl:param name="replace"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="function-available('str:replace')">
                    <xsl:value-of select="str:replace($string, $lookup, $replace)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="replace-string">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="lookup" select="$lookup"/>
                        <xsl:with-param name="replace" select="$replace"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
	<!-- named helper template  -->
	<xsl:template name="replace-string">
        <xsl:param name="string"/>
        <xsl:param name="lookup"/>
        <xsl:param name="replace"/>
		<xsl:variable name="first" select="substring-before($string, $lookup)"/>
		<xsl:choose>
			<xsl:when test="$first = ''">
				<xsl:value-of select="$string"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="rs">
					<xsl:call-template name="replace-string">
						<xsl:with-param name="string" select="substring-after($string, $lookup)"/>
						<xsl:with-param name="lookup" select="$lookup"/>
						<xsl:with-param name="replace" select="$replace"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="result" select="concat($first, $replace, $rs)"/>
				<xsl:value-of select="$result"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    
    <!--
      ** Function: upper-case
      ** @param string
      ** @return string in upper case letter
      -->
    <func:function name="kde:upper-case">
        <xsl:param name="string"/>
        <func:result select="translate($string, 
                                       'abcdefghijklmnopqrstuvwxyz',
                                       'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/> 
    </func:function>
    

    <!--
      ** Function: lower-case
      ** @param string
      ** @return string in upper case letter
      -->
    <func:function name="kde:lower-case">
        <xsl:param name="string"/>
        <func:result select="translate($string, 
                                       'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 
                                       'abcdefghijklmnopqrstuvwxyz')"/>
    </func:function>
    
    <!--
      ** Function: upper-first
      ** @param string
      ** @return string with first character as upper case letter
      -->
    <func:function name="kde:upper-first">
        <xsl:param name="string"/>
        <xsl:variable name="rest" select="substring($string, 2)"/>
        <xsl:variable name="head" select="kde:upper-case(substring($string, 1, 1))"/>
        <func:result>
            <xsl:value-of select="concat($head, $rest)"/>
        </func:result>    
    </func:function>

    <!--
      ** Function: repeat
      ** @param string
      ** @param times
      ** @return 'times' copies of string
      -->
    <func:function name="kde:repeat">
        <xsl:param name="string"/>
        <xsl:param name="times"/>
        <xsl:variable name="copy" select="$string"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$times &lt;= 0"><xsl:value-of select="''"/></xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($string, kde:repeat($copy, $times - 1))"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!--
      ** Function: getNodeName
      ** @param node
      ** @return the (variable) name of a node 
      -->
    <func:function name="kde:getNodeName">
        <xsl:param name="node" select="."/>
        <func:result>
			<xsl:call-template name="getNodeName">
				<xsl:with-param name="node" select="$node"/>
			</xsl:call-template>
        </func:result>
    </func:function>
	<xsl:template name="getNodeName">
        <xsl:param name="node" select="."/>
		<xsl:variable name="name" select="$node/property[@name = 'name']/cstring"/>
		<xsl:choose>
			<xsl:when test="$name = 'unnamed'">
				<xsl:variable name="pname">
					<xsl:call-template name="getNodeName">
						<xsl:with-param name="node" select="$node/.."/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($pname, kde:upper-first(name($node)))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <!--
      ** Templates to "print" xml in text output mode
    -->
    <xsl:template match="*" mode="print">
        <xsl:value-of select="concat('&lt;', name())"/>
        <xsl:apply-templates select="@*" mode="print"/>
        <xsl:value-of select="'&gt;'"/>
        <xsl:apply-templates mode="print"/> 
        <xsl:value-of select="concat('&lt;/', name(), '&gt;')"/>
    </xsl:template>
    <xsl:template match="@*" mode="print">
        <xsl:value-of select="concat(' ', name(), '=&quot;', ., '&quot;')"/>
    </xsl:template>
    
    
    <!--
      ** Print the path from the root to a given node
      -->
    <func:function name="kde:printPath">
        <xsl:param name="node"/>
        <xsl:param name="path" select="''"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$node = /UI">
                    <xsl:value-of select="concat('/UI', $path)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="kde:printPath($node/.., 
														concat('/',
                                                               name($node), 
                                                               '[',
															   count($node/preceding-sibling::*[name() = name($node)]) + 1, 
															   ']',
                                                               $path))"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    


</xsl:stylesheet>

