// $Id: dcop_imp.cpp,v 1.8 2004/01/01 07:23:14 geiseri Exp $
// -*- c++ -*-

/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */
#include <kapplication.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kregexp.h>

#include "dcop_imp.h"
#include "dcop_imp.moc"

#include <kdatastream.h>
#include <qvariant.h>
#include <qstring.h>
#include <qmap.h>
#include <qfont.h>
#include <qpixmap.h>
#include <qbrush.h>
#include <qrect.h>
#include <qsize.h>
#include <qcolor.h>
#include <qimage.h>
#include <qpoint.h>
#include <qvaluelist.h>
#include <qiconset.h>
#include <qpointarray.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qmemarray.h>
#include <qkeysequence.h>
#include <qbitarray.h>

#include <kjs/interpreter.h>
#include <kjs/types.h>
#include <kjs/ustring.h>
#include <kjs/value.h>

#include "../jsbinding.h"
#include <kjsembed/jsopaqueproxy.h>

namespace KJSEmbed {
namespace Bindings {

JSDCOPClient::JSDCOPClient( KJS::ExecState *exec, int id  )
    : JSProxyImp(exec), mid(id)
{
	kdDebug() << "New DCOP Client..." << endl;
}

JSDCOPClient::~JSDCOPClient()
{
	kdDebug() << "Going away..." << endl;
}

 
void JSDCOPClient::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    kdDebug() << "JSDCOPClient::addBindings()" << endl;
    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( object.imp() );
    if ( !op ) {
        kdWarning() << "JSDCOPClient::addBindings() failed, not a JSOpaqueProxy" << endl;
        return;
    }

    if ( op->typeName() != "DCOPClient" ) {
	kdWarning() << "JSDCOPClient::addBindings() failed, type is " << op->typeName() << endl;
	return;
    }

    JSProxy::MethodTable methods[] = {
	{ Methodattach, "attach"},
	{ Methoddetach, "detach"},
	{ MethodisAttached, "isAttached" },
	{ MethodregisteredApplications, "registeredApplications" },
	{ MethodremoteObjects, "remoteObjects" },
	{ MethodremoteInterfaces, "remoteInterfaces" },
	{ MethodremoteFunctions, "remoteFunctions" },
	{ MethodconnectDCOPSignal, "connectDCOPSignal" },
	{ MethoddisconnectDCOPSignal, "disconnectDCOPSignal"},
	{ Methodcall, "call"},
	{ Methodsend, "send"},
	{ 0, 0 }
    };

    int idx = 0;
    do {
        JSDCOPClient *meth = new JSDCOPClient( exec, methods[idx].id );
        object.put( exec , methods[idx].name, KJS::Object(meth) );
        ++idx;
    } while( methods[idx].id );

}

KJS::Value JSDCOPClient::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args ) {

    kdDebug() << "JSDCOPClient::call() " << mid << endl;
    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op ) {
        kdWarning() << "JSDCOPClient::call() failed, not a JSOpaqueProxy" << endl;
        return KJS::Value();
    }

    if ( op->typeName() != "DCOPClient" ) {
	kdWarning() << "JSDCOPClient::call() failed, type is " << op->typeName() << endl;
	return KJS::Value();
    }
    
    KJS::Value retValue = KJS::Value();
    switch ( mid ) {
        case Methodattach: {
	    retValue = KJS::Boolean(attach( ));
	    break;
	}
	case Methoddetach: {
	    retValue = KJS::Boolean(detach( ));
	    break;
	}
	case MethodisAttached: {
	    retValue = KJS::Boolean(isAttached( ));
	    break;
	}
	case MethodregisteredApplications: {
	    retValue = convertToValue(exec, registeredApplications());
	    break;
	}
	case MethodremoteObjects: {
	    QString arg0 = (args.size() > 0) ? args[0].toString(exec).qstring() : QString::null;
	    retValue = convertToValue( exec, this->remoteObjects(arg0));
	    break;
	}
	case MethodremoteInterfaces: {
	    QString arg0 = (args.size() > 0) ? args[0].toString(exec).qstring() : QString::null;
	    QString arg1 = (args.size() > 1) ? args[1].toString(exec).qstring() : QString::null;
	    this->remoteInterfaces(arg0, arg1);
	    break;
	}
	case MethodremoteFunctions: {
	    QString arg0 = (args.size() > 0) ? args[0].toString(exec).qstring() : QString::null;
	    QString arg1 = (args.size() > 1) ? args[1].toString(exec).qstring() : QString::null;
	    remoteFunctions(arg0, arg1);
	    break;
	}
	case MethodconnectDCOPSignal: {
	    QString arg0 = (args.size() > 0) ? args[0].toString(exec).qstring() : QString::null;
	    QString arg1 = (args.size() > 1) ? args[1].toString(exec).qstring() : QString::null;
	    QString arg2 = (args.size() > 2) ? args[2].toString(exec).qstring() : QString::null;
	    QString arg3 = (args.size() > 3) ? args[3].toString(exec).qstring() : QString::null;
	    QString arg4 = (args.size() > 4) ? args[4].toString(exec).qstring() : QString::null;
	    bool arg5 = (args.size() > 5) ? args[5].toBoolean(exec) : false;
	    connectDCOPSignal( arg0, arg1, arg2, arg3, arg4, arg5);
	    break;
	}
	case MethoddisconnectDCOPSignal: {
	    QString arg0 = (args.size() > 0) ? args[0].toString(exec).qstring() : QString::null;
	    QString arg1 = (args.size() > 1) ? args[1].toString(exec).qstring() : QString::null;
	    QString arg2 = (args.size() > 2) ? args[2].toString(exec).qstring() : QString::null;
	    QString arg3 = (args.size() > 3) ? args[3].toString(exec).qstring() : QString::null;
	    QString arg4 = (args.size() > 4) ? args[4].toString(exec).qstring() : QString::null;
	    disconnectDCOPSignal(arg0, arg1, arg2, arg3, arg4);
	    break;
	}
	case Methodsend:
		return dcopSend( exec, self, args );
	case Methodcall:
		return dcopCall( exec, self, args );
        default:
        kdWarning() << "JSDCOPClient has no method " << mid << endl;
        break;
    }
    return retValue;
}

bool JSDCOPClient::attach() const
{
	return kapp->dcopClient()->attach();
}
bool JSDCOPClient::detach() const
{	return kapp->dcopClient()->detach();

}

bool JSDCOPClient::isAttached() const
{
	kdDebug() << "Calling isAttached()" << endl;
	return kapp->dcopClient()->isAttached();
}

KJS::Value JSDCOPClient::dcopCall( KJS::ExecState * exec, KJS::Object &, const KJS::List & args )
{
	if ( args.size() < 3 )
		return KJS::Boolean(false);

	QByteArray data, replyData;
	QCString type;

	QString app = args[0].toString(exec).qstring();
	QString interface = args[1].toString(exec).qstring();
	QString function = args[2].toString(exec).qstring();

	if( args.size() > 3)
		for( int idx = 3; idx < args.size(); ++idx)
		{
			marshall(convertToVariant(exec,args[idx] ), data);
		}
	if( !kapp->dcopClient()->call(app.local8Bit(), interface.local8Bit(), function.local8Bit(), data, type, replyData))
		return KJS::Boolean(false);
	else
		return convertToValue(exec, demarshall(type, replyData));
}

KJS::Value JSDCOPClient::dcopSend( KJS::ExecState * exec, KJS::Object &, const KJS::List & args )
{
	if ( args.size() < 3 )
		return KJS::Boolean(false);

	QByteArray data;
	QString app = args[0].toString(exec).qstring();
	QString interface = args[1].toString(exec).qstring();
	QString function = args[2].toString(exec).qstring();

	if( args.size() > 3)
		for( int idx = 3; idx < args.size(); ++idx)
		{
			marshall(convertToVariant(exec,args[idx] ), data);
		}
	return KJS::Boolean( kapp->dcopClient()->send(app.local8Bit(), interface.local8Bit(), function.local8Bit(), data));
}

QVariant JSDCOPClient::demarshall( const QCString& type, const QByteArray& data)
{

	QDataStream reply( data , IO_ReadOnly);
	kdDebug() << "Demarshall " << type << endl;

	return demarshall( type, reply );

}

void JSDCOPClient::marshall( const QVariant& data, QByteArray& buffer )
{
	kdDebug() << "Marshall " << data.typeName()  <<  endl;

	QDataStream stream(buffer, IO_WriteOnly | IO_Append);

	if ( data.type() == QVariant::String )
	{
		stream << data.toString();
	}
	else if ( data.type() == QVariant::CString)
	{
		stream << data.toCString();
	}
	else if ( data.type() == QVariant::Int)
	{
		stream << data.toInt();
	}
	else if ( data.type() == QVariant::UInt)
	{
		stream << data.toUInt();
	}
	else if ( data.type() == QVariant::Bool)
	{
		stream << data.toBool();
	}
	else if ( data.type() == QVariant::Double)
	{
		stream << data.toDouble();
	}
	else if ( data.type() == QVariant::Map )
	{
		stream << data.toMap();
	}
	else if ( data.type() == QVariant::List)
	{
		stream << data.toList();
	}
	else if ( data.type() == QVariant::Font)
	{
		stream << data.toFont();
	}
	else if ( data.type() == QVariant::Pixmap)
	{
		stream << data.toPixmap();
	}
	else if ( data.type() == QVariant::Brush)
	{
		stream << data.toBrush();
	}
	else if ( data.type() == QVariant::Rect)
	{
		stream << data.toRect();
	}
	else if ( data.type() == QVariant::Size)
	{
		stream << data.toSize();
	}
	else if ( data.type() == QVariant::Color)
	{
		stream << data.toColor();
	}
	else if ( data.type() == QVariant::Palette)
	{
		stream << data.toPalette();
	}
	else if ( data.type() == QVariant::ColorGroup)
	{
		stream << data.toColorGroup();
	}
	/*else if ( data.type() == "QIconSet")
	{
		stream << data.toIconSet();
	}*/
	else if ( data.type() == QVariant::Point)
	{
		stream << data.toPoint();
	}
	else if ( data.type() == QVariant::Image)
	{
		stream << data.toImage();
	}
	else if ( data.type() == QVariant::PointArray)
	{
		stream << data.toPointArray();
	}
	else if ( data.type() == QVariant::Region)
	{
		stream << data.toRegion();
	}
	else if ( data.type() == QVariant::Bitmap)
	{
		stream << data.toBitmap();
	}
	else if ( data.type() == QVariant::Cursor)
	{
		stream << data.toCursor();
	}
	/*else if ( data.type() == "QSizePolicy")
	{
		stream << data.toSizePolicy();
	}*/
	else if ( data.type() == QVariant::Date)
	{
		stream << data.toDate();
	}
	else if ( data.type() == QVariant::Time)
	{
		stream << data.toTime();
	}
	else if ( data.type() == QVariant::DateTime)
	{
		stream << data.toDateTime();
	}
	else if ( data.type() == QVariant::ByteArray)
	{
		stream << data.toByteArray();
	}
	else if ( data.type() == QVariant::BitArray)
	{
		stream << data.toBitArray();
	}
	else if ( data.type() == QVariant::KeySequence)
	{
		stream << data.toKeySequence();
	}
	else
		stream << 0;

}

QStringList JSDCOPClient::remoteFunctions( const QString & remApp, const QString & remObj )
{
	QStringList returnList;
	QCStringList lst = kapp->dcopClient()->remoteFunctions(remApp.local8Bit(), remObj.local8Bit());
	for(uint idx = 0; idx < lst.count(); ++idx)
		returnList += lst[idx];
	return returnList;
}

QStringList JSDCOPClient::remoteInterfaces( const QString & remApp, const QString & remObj )
{
	QStringList returnList;
	QCStringList lst = kapp->dcopClient()->remoteInterfaces(remApp.local8Bit(), remObj.local8Bit());
	for(uint idx = 0; idx < lst.count(); ++idx)
		returnList += lst[idx];
	return returnList;
}

QStringList JSDCOPClient::remoteObjects( const QString & remApp )
{
	QStringList returnList;
	QCStringList lst = kapp->dcopClient()->remoteObjects(remApp.local8Bit());
	for(uint idx = 0; idx < lst.count(); ++idx)
		returnList += lst[idx];
	return returnList;
}

QStringList JSDCOPClient::registeredApplications( )
{
	QStringList returnList;
	QCStringList lst = kapp->dcopClient()->registeredApplications( );
	for(uint idx = 0; idx < lst.count(); ++idx)
		returnList += lst[idx];
	return returnList;
}

bool JSDCOPClient::connectDCOPSignal (const QString &sender, const QString &senderObj, const QString &signal, const QString &receiverObj, const QString &slot, bool Volatile)
{
	return kapp->dcopClient()->connectDCOPSignal(sender.latin1(), senderObj.latin1(), signal.latin1(), receiverObj.latin1(), slot.latin1(), Volatile);
}

bool JSDCOPClient::disconnectDCOPSignal (const QString &sender, const QString &senderObj, const QString &signal, const QString &receiverObj, const QString &slot)
{
	return kapp->dcopClient()->disconnectDCOPSignal(sender.latin1(), senderObj.latin1(), signal.latin1(), receiverObj.latin1(), slot.latin1());
}

void JSDCOPInterface::publish( const QString & signature )
{
	if( m_Members.find(signature.latin1() ) == m_Members.end())
		m_Members.append(signature.latin1() );
}

JSDCOPInterface::~ JSDCOPInterface( )
{
}

JSDCOPInterface::JSDCOPInterface( KJS::Interpreter *js, QObject * parent, const char * name )
	: BindingObject( parent, name ),DCOPObject(name), m_js(js)
{
	m_Members.clear();
}

QCStringList JSDCOPInterface::functionsDynamic( )
{
	return m_Members;
}

bool JSDCOPInterface::processDynamic( const QCString & rawFunction, const QByteArray & data, QCString & replyType, QByteArray & replyData )
{
	kdDebug() << "Calling " << replyType << " " << rawFunction << endl;
	KRegExp reg = KRegExp("([_\\d\\w]+)(\\()(.+)(\\))");
	reg.match(rawFunction);
	QString signature = reg.group(1);
	QStringList argStrings = QStringList::split(',', reg.group(3), false);
	QDataStream ds(data, IO_ReadOnly);

	KJS::ExecState *exec = m_js->globalExec();
	KJS::Object obj = m_js->globalObject();

	KJS::List args;
	for( uint idx = 0; idx < argStrings.count(); ++idx)
	{
		QString arg = argStrings[idx];
		args.append(convertToValue(exec, JSDCOPClient::demarshall(arg.latin1(), ds)));
	}

	KJS::Identifier *id =new KJS::Identifier(KJS::UString(signature));
	KJS::Object fun = obj.get(exec, *id ).toObject( exec );
	KJS::Value retValue;
	if ( !fun.implementsCall() )
		return false;
	else
		retValue = fun.call(exec, obj, args);
	QVariant returnVariant = convertToVariant(exec, retValue);
	JSDCOPClient::marshall(returnVariant , replyData);
	replyType = returnVariant.typeName();
	return true;

}

QVariant JSDCOPClient::demarshall( const QCString & type, QDataStream & reply )
{
	/*if ( type == "QMap" )  // ? dont handle?
	{
		QMap<QVariant, QVariant> result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QValueList") // ? dont handle?
	{
		QValueList<QVariant> result;
		reply >> result;
		return QVariant(result);
	}else if ( type == "QVariantList")
	{
		QVariantList result;
		reply >> result;
		return QVariant(result);
	}
	else */
	if ( type == "QString")
	{
		QString result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "int")
	{
		int result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "uint")
	{
		uint result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "bool")
	{
		bool result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "double")
	{
		double result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QCString")
	{
		QCString result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QVariant")
	{
		QVariant result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QFont")
	{
		QFont result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QPixmap")
	{
		QPixmap result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QBrush")
	{
		QBrush result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QRect")
	{
		QRect result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QSize")
	{
		QSize result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QColor")
	{
		QColor result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QPalette")
	{
		QPalette result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QColorGroup")
	{
		QColorGroup result;
		reply >> result;
		return QVariant(result);
	}
	/*else if ( type == "QIconSet")
	{
		QIconSet result;
		reply >> result;
		return QVariant(result);
	}*/
	else if ( type == "QPoint")
	{
		QPoint result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QImage")
	{
		QImage result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QPointArray")
	{
		QPointArray result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QRegion")
	{
		QRegion result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QBitmap")
	{
		QBitmap result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QCursor")
	{
		QCursor result;
		reply >> result;
		return QVariant(result);
	}
	/*else if ( type == "QSizePolicy")
	{
		QSizePolicy result;
		reply >> result;
		return QVariant(result);
	}*/
	else if ( type == "QDate")
	{
		QDate result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QTime")
	{
		QTime result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QDateTime")
	{
		QDateTime result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QByteArray")
	{
		QByteArray result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QBitArray")
	{
		QBitArray result;
		reply >> result;
		return QVariant(result);
	}
	else if ( type == "QKeySequence")
	{
		QKeySequence result;
		reply >> result;
		return QVariant(result);
	}
	else
		return QVariant();

}
} // namespace Bindings
} // namespace KJSEmbed




