/***************************************************************************
                            KPropertiesDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROPERTIESDIALOG_H
#define KPROPERTIESDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 The main properties dialog class.
 A Properties Dialog is a dialog which displays various information
 about a particular file or URL, or several ones.
 This main class holds various related classes, which are instantiated in
 the form of tab entries in the tabbed dialog that this class provides.
 The various tabs themselves will let the user view or change information
 about the file or URL.

 This class must be created with (void)new KPropertiesDialog(...)
 It will take care of deleting itself.
 
 @short 
 The main properties dialog class.
*/
@class KFileItem; 
@class KPropsDlgPlugin; 
@class KURL; 

@interface KPropertiesDialog : KDialogBase 

/** 
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.  Normally you will use this
 method rather than the one below.

*/
- initWithFileItem: (KFileItem*)item parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal autoShow: (BOOL)autoShow;
- initWithFileItem: (KFileItem*)item ;

/** 
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.

*/
- initWithArray: (NSArray *)_items parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal autoShow: (BOOL)autoShow;
- initWithArray: (NSArray *)_items ;

/** 
 Brings up a Properties dialog. Convenience constructor for
 non-file-manager applications.

*/
//- initWithURL: (KURL*)_url mode_t: (mode_t _mode  -1)arg1 parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal autoShow: (BOOL)autoShow;
//- initWithURL: (KURL*)_url ;

/** 
 Creates a properties dialog for a new .desktop file (whose name
 is not known yet), based on a template. Special constructor for
 "File / New" in file-manager applications.

*/
- initWithURL: (KURL*)_tempUrl _currentDir: (KURL*)_currentDir _defaultName: (NSString *)_defaultName parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal autoShow: (BOOL)autoShow;
- initWithURL: (KURL*)_tempUrl _currentDir: (KURL*)_currentDir _defaultName: (NSString *)_defaultName ;

/** 
 Creates an empty properties dialog (for applications that want use
 a standard dialog, but for things not doable via the plugin-mechanism).

*/
- initWithText: (NSString *)title parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- initWithText: (NSString *)title ;

/** 
 Cleans up the properties dialog and frees any associated resources,
 including the dialog itself. Note that when a properties dialog is
 closed it cleans up and deletes itself.
   
*/
- (void) dealloc;

/** 
 Adds a "3rd party" properties plugin to the dialog.  Useful
 for extending the properties mechanism.

 To create a new plugin type, inherit from the base class KPropsPlugin
 and implement all the methods. If you define a service .desktop file
 for your plugin, you do not need to call -insertPlugin.

*/
- insertPlugin: (KPropsDlgPlugin*)plugin;

/** 

*/
- (KURL*) kurl;

/** 

*/
- (KFileItem*) item;

/** 

*/
- (NSArray *) items;

/** 

   
*/
- (KDialogBase*) dialog;
- (KDialogBase*) dialog;

/** 
 If we are building this dialog from a template,

*/
- (KURL*) currentDir;

/** 
 If we are building this dialog from a template,

*/
- (NSString *) defaultName;

/** 
 Updates the item url (either called by rename or because
 a global apps/mimelnk desktop file is being saved)
 Can only be called if the dialog applies to a single file/URL.

*/
- updateUrl: (KURL*)_newUrl;

/** 
  #-see -[FilePropsPlugin applyChanges]Can only be called if the dialog applies to a single file/URL.

*/
- rename: (NSString *)_name;

/** 
 To abort applying changes.
   
*/
- abortApplying;

/** 
 Called when the user presses 'Ok'.
   
*/
- slotOk;
- slotCancel;

/** 

*/
+ (BOOL) canDisplay: (NSArray *)_items;
@end

/** Override these methods in subclasses of KPropertiesDialog to customise event handling behaviour */
@protocol KPropertiesDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
