//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QWidget;

/**

 This dialog asks the user to enter a password. The functions you're
 probably interested in are the static methods, getPassword() and
 getNewPassword().
 <li><b>Usage example</b></li>
 <pre>
 String password;
 int result = KPasswordDialog.getPassword(password, i18n("Password"));
 if (result == KPasswordDialog.Accepted)
     use(password);
 </pre>
 <li><b>Security notes:</b></li>
 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

	<li>
	You may want to use disableCoreDump() to disable core dumps.
	 Core dumps are dangerous because they are an image of the process memory,
	 and thus include any passwords that were in memory.
	</li>
	
	<li>
	You should delete passwords as soon as they are not needed anymore.
	 The functions getPassword() and getNewPassword() return the
	 password as a String. I believe this is safer than a String. A String
	 stores its characters internally as 16-bit wide values, so conversions are
	 needed, both for creating the String and by using it. The temporary
	 memory used for these conversion is probably not erased. This could lead
	 to stray  passwords in memory, even if you think you erased all of them.
	</li>
			@author Geert Jansen <jansen@kde.org>
 
		@short A password input dialog.

*/
public class KPasswordDialog extends KDialogBase  {
	protected KPasswordDialog(Class dummy){super((Class) null);}
	/**	
		 This enum distinguishes the two operation modes of this dialog:
		     		@short    This enum distinguishes the two operation modes of this dialog:
	*/
	public static final int Password = 0;
	public static final int NewPassword = 1;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a password dialog.
			@param type : if NewPassword is given here, the dialog contains two
		        input fields, so that the user must confirm his password
		        and possible typos are detected immediately.
			@param enableKeep : if true, a check box is shown in the dialog
		        which allows the user to keep his password input for later.
			@param extraBttn : allows to show additional buttons, KDialogBase.
			@param parent Passed to lower level constructor.
			@param name Passed to lower level constructor
				@short    Constructs a password dialog.
	*/
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent, String name) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,parent,name);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent, String name);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,parent);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn);
	/**	
		 Sets the password prompt.
		     		@short    Sets the password prompt.
	*/
	public native void setPrompt(String prompt);
	/**	
		 Returns the password prompt.
		     		@short    Returns the password prompt.
	*/
	public native String prompt();
	/**	
		 Adds a line of information to the dialog.
		     		@short    Adds a line of information to the dialog.
	*/
	public native void addLine(String key, String value);
	/**	
		 Returns the password entered. The memory is freed in the destructor,
		 so you should make a copy.
		     		@short    Returns the password entered.
	*/
	public native String password();
	/**	
		 Returns true if the user wants to keep the password.
		     		@short    Returns true if the user wants to keep the password.
	*/
	public native boolean keep();
	/**	
		 Pops up the dialog, asks the user for a password, and returns it.
			@param password The password is returned in this reference parameter.
			@param prompt A prompt for the password. This can be a few lines of
		 information. The text is word broken to fit nicely in the dialog.
			@param keep Enable/disable a checkbox controlling password keeping.
		 If you pass a null pointer, or a pointer to the value 0, the checkbox
		 is not shown. If you pass a pointer to a nonzero value, the checkbox
		 is shown and the result is stored in keep.
				@return Result code: Accepted or Rejected.
     
		@short    Pops up the dialog, asks the user for a password, and returns it.
	*/
	public static native int getPassword(StringBuffer password, String prompt, int[] keep);
	public static native int getPassword(StringBuffer password, String prompt);
	/**	
		 Pops up the dialog, asks the user for a password and returns it. The
		 user has to enter the password twice to make sure it was entered
		 correctly.
			@param password The password is returned in this reference parameter.
			@param prompt A prompt for the password. This can be a few lines of
		 information. The text is word broken to fit nicely in the dialog.
				@return Result code: Accepted or Rejected.
     
		@short    Pops up the dialog, asks the user for a password and returns it.
	*/
	public static native int getNewPassword(StringBuffer password, String prompt);
	/**	
		 Static helper function that disables core dumps.
		     		@short    Static helper function that disables core dumps.
	*/
	public static native void disableCoreDumps();
	/**	
		 Virtual function that can be overridden to provide password
		 checking in derived classes. It should return <code>true</code> if the
		 password is valid, <code>false</code> otherwise.
		     		@short    Virtual function that can be overridden to provide password  checking in derived classes.
	*/
	protected native boolean checkPassword(String arg1);
	protected native void slotOk();
	protected native void slotCancel();
	protected native void slotKeep(boolean arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
