//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 The <code>Document</code> interface represents the entire HTML or
 XML document. Conceptually, it is the root of the document tree,
 and provides the primary access to the document's data.
  Since elements, text nodes, comments, processing instructions,
 etc. cannot exist outside the context of a <code>Document</code>
 , the <code>Document</code> interface also contains the factory
 methods needed to create these objects. The <code>Node</code>
 objects created have a <code>ownerDocument</code> attribute which
 associates them with the <code>Document</code> within whose
 context they were created.
 		@short    The <code>Document</code> interface represents the entire HTML or  XML document.

*/
public class Document extends Node  {
	protected Document(Class dummy){super((Class) null);}
	public Document() {
		super((Class) null);
		newDocument();
	}
	private native void newDocument();
	/**	
		 don't create an implementation if false
		 use at own risk
		     		@short    don't create an implementation if false  use at own risk
	*/
	public Document(boolean arg1) {
		super((Class) null);
		newDocument(arg1);
	}
	private native void newDocument(boolean arg1);
	public Document(Document other) {
		super((Class) null);
		newDocument(other);
	}
	private native void newDocument(Document other);
	public Document(Node other) {
		super((Class) null);
		newDocument(other);
	}
	private native void newDocument(Node other);
	/**	
		 The Document Type Declaration (see <code>DocumentType</code>
		 ) associated with this document. For HTML documents as well as
		 XML documents without a document type declaration this returns
		 <code>null</code> . The DOM Level 1 does not support editing
		 the Document Type Declaration, therefore <code>docType</code>
		 cannot be altered in any way.
			     		@short    The Document Type Declaration (see <code>DocumentType</code>  ) associated with this document.
	*/
	public native DocumentType doctype();
	/**	
		 The <code>DOMImplementation</code> object that handles this
		 document. A DOM application may use objects from multiple
		 implementations.
			     		@short    The <code>DOMImplementation</code> object that handles this  document.
	*/
	public native DOMImplementation implementation();
	/**	
		 This is a convenience attribute that allows direct access to
		 the child node that is the root element of the document. For
		 HTML documents, this is the element with the tagName "HTML".
			     		@short    This is a convenience attribute that allows direct access to  the child node that is the root element of the document.
	*/
	public native Element documentElement();
	/**	
		 Creates an element of the type specified. Note that the
		 instance returned implements the Element interface, so
		 attributes can be specified directly on the returned object.
			@param tagName The name of the element type to instantiate. For
		 XML, this is case-sensitive. For HTML, the <code>tagName</code>
		 parameter may be provided in any case, but it must be
		 mapped to the canonical uppercase form by the DOM
		 implementation.
			     		@return A new <code>Element</code> object.

		@short    Creates an element of the type specified.
	*/
	public native Element createElement(String tagName);
	/**	
		 Introduced in DOM Level 2
		 Creates an element of the given qualified name and namespace URI.
			@param namespaceURI The namespace URI of the element to create.
			@param qualifiedName The qualified name of the element type to instantiate.
				@return A new Element object with the following attributes:

		@short    Introduced in DOM Level 2  Creates an element of the given qualified name and namespace URI.
	*/
	public native Element createElementNS(String namespaceURI, String qualifiedName);
	/**	
		 Creates an empty <code>DocumentFragment</code> object.
			     		@return A new <code>DocumentFragment</code> .

		@short    Creates an empty <code>DocumentFragment</code> object.
	*/
	public native DocumentFragment createDocumentFragment();
	/**	
		 Creates a <code>Text</code> node given the specified string.
			@param data The data for the node.
			     		@return The new <code>Text</code> object.

		@short    Creates a <code>Text</code> node given the specified string.
	*/
	public native Text createTextNode(String data);
	/**	
		 Creates a <code>Comment</code> node given the specified
		 string.
			@param data The data for the node.
			     		@return The new <code>Comment</code> object.

		@short    Creates a <code>Comment</code> node given the specified  string.
	*/
	public native Comment createComment(String data);
	/**	
		 Creates a <code>CDATASection</code> node whose value is the
		 specified string.
			@param data The data for the <code>CDATASection</code>
		 contents.
			     		@return The new <code>CDATASection</code> object.

		@short    Creates a <code>CDATASection</code> node whose value is the  specified string.
	*/
	public native CDATASection createCDATASection(String data);
	/**	
		 Creates a <code>ProcessingInstruction</code> node given the
		 specified name and data strings.
			@param target The target part of the processing instruction.
			@param data The data for the node.
			  NOT_SUPPORTED_ERR: Raised if this document is an HTML
		 document.
			     		@return The new <code>ProcessingInstruction</code> object.

		@short    Creates a <code>ProcessingInstruction</code> node given the  specified name and data strings.
	*/
	public native ProcessingInstruction createProcessingInstruction(String target, String data);
	/**	
		 Creates an <code>Attr</code> of the given name. Note that the
		 <code>Attr</code> instance can then be set on an <code>Element</code>
		 using the <code>setAttribute</code> method.
			@param name The name of the attribute.
			     		@return A new <code>Attr</code> object.

		@short    Creates an <code>Attr</code> of the given name.
	*/
	public native Attr createAttribute(String name);
	/**	
		 Introduced in DOM Level 2
		 Creates an attribute of the given qualified name and namespace URI.
		 HTML-only DOM implementations do not need to implement this method.
			@param namespaceURI The namespace URI of the attribute to create.
			@param qualifiedName The qualified name of the attribute to instantiate.
				@return A new Attr object with the following attributes:
 Node.nodeName - qualifiedName
 Node.namespaceURI - namespaceURI
 Node.prefix - prefix, extracted from qualifiedName, or null if there is
 no prefix
 Node.localName - local name, extracted from qualifiedName
 Attr.name - qualifiedName
 Node.nodeValue - the empty string

		@short    Introduced in DOM Level 2  Creates an attribute of the given qualified name and namespace URI.
	*/
	public native Attr createAttributeNS(String namespaceURI, String qualifiedName);
	/**	
		 Creates an EntityReference object.
			@param name The name of the entity to reference.
			  NOT_SUPPORTED_ERR: Raised if this document is an HTML
		 document.
			     		@return The new <code>EntityReference</code> object.

		@short    Creates an EntityReference object.
	*/
	public native EntityReference createEntityReference(String name);
	/**	
		 Moved from HTMLDocument in DOM Level 2
		 Returns the Element whose <code>id</code> is given by
		 elementId. If no such element exists, returns <code>null</code>
		 . Behavior is not defined if more than one element has
		 this <code>id</code> .
			@param elementId The unique <code>id</code> value for an
		 element.
			     		@return The matching element.

		@short    Moved from HTMLDocument in DOM Level 2  Returns the Element whose <code>id</code> is given by  elementId.
	*/
	public native Element getElementById(String elementId);
	/**	
		 No Exceptions.
			 Returns a <code>ArrayList</code> of all the <code>Element</code> 's
		 with a given tag name in the order in which they
		 would be encountered in a preorder traversal of the
		 <code>Document</code> tree.
			@param tagname The name of the tag to match on. The special
		 value "*" matches all tags.
			     		@return A new <code>NodeList</code> object containing all the
 matched <code>Element</code> s.

		@short    No Exceptions.
	*/
	public native ArrayList getElementsByTagName(String tagname);
	/**	
		 Introduced in DOM Level 2
		 No Exceptions
			 Returns an ArrayList of all the Elements with a given local name and
		 namespace URI in the order in which they are encountered in a preorder
		 traversal of the Document tree.
			@param namespaceURI The namespace URI of the elements to match on. The
		 special value "*" matches all namespaces.
			@param localName The local name of the elements to match on. The special
		 value "*" matches all local names.
				@return A new NodeList object containing all the matched Elements.
     
		@short    Introduced in DOM Level 2  No Exceptions
	*/
	public native ArrayList getElementsByTagNameNS(String namespaceURI, String localName);
	/**	
		 Introduced in DOM Level 2
			 Imports a node from another document to this document. The returned node
		 has no parent; (parentNode is null). The source node is not altered or
		 removed from the original document; this method creates a new copy of
		 the source node.
			 For all nodes, importing a node creates a node object owned by the
		 importing document, with attribute values identical to the source node's
		 nodeName and nodeType, plus the attributes related to namespaces
		 (prefix, localName, and namespaceURI).
			 As in the cloneNode operation on a Node, the source node is not altered.
		 Additional information is copied as appropriate to the nodeType,
		 attempting to mirror the behavior expected if a fragment of XML or HTML
		 source was copied from one document to another, recognizing that the two
		 documents may have different DTDs in the XML case. The following list
		 describes the specifics for each type of node.
			 ATTRIBUTE_NODE
		 The ownerElement attribute is set to null and the specified flag is set
		 to true on the generated Attr. The descendants of the source Attr are
		 recursively imported and the resulting nodes reassembled to form the
		 corresponding subtree. Note that the deep parameter has no effect on
		 Attr nodes; they always carry their children with them when imported.
			 DOCUMENT_FRAGMENT_NODE
		 If the deep option was set to true, the descendants of the source
		 element are recursively imported and the resulting nodes reassembled to
		 form the corresponding subtree. Otherwise, this simply generates an
		 empty DocumentFragment.
			 DOCUMENT_NODE
		 Document nodes cannot be imported.
			 DOCUMENT_TYPE_NODE
		 DocumentType nodes cannot be imported.
			 ELEMENT_NODE
		 Specified attribute nodes of the source element are imported, and the
		 generated Attr nodes are attached to the generated Element. Default
		 attributes are not copied, though if the document being imported into
		 defines default attributes for this element name, those are assigned. If
		 the importNode deep parameter was set to true, the descendants of the
		 source element are recursively imported and the resulting nodes
		 reassembled to form the corresponding subtree.
			 ENTITY_NODE
		 Entity nodes can be imported, however in the current release of the DOM
		 the DocumentType is readonly. Ability to add these imported nodes to a
		 DocumentType will be considered for addition to a future release of the
		 DOM.
		 On import, the publicId, systemId, and notationName attributes are
		 copied. If a deep import is requested, the descendants of the the source
		 Entity are recursively imported and the resulting nodes reassembled to
		 form the corresponding subtree.
			 ENTITY_REFERENCE_NODE Only the EntityReference itself is copied, even if
		 a deep import is requested, since the source and destination documents
		 might have defined the entity differently. If the document being
		 imported into provides a definition for this entity name, its value is
		 assigned.
			 NOTATION_NODE
		 Notation nodes can be imported, however in the current release of the
		 DOM the DocumentType is readonly. Ability to add these imported nodes to
		 a DocumentType will be considered for addition to a future release of
		 the DOM.
		 On import, the publicId and systemId attributes are copied.
		 Note that the deep parameter has no effect on Notation nodes since they
		 never have any children.
			 PROCESSING_INSTRUCTION_NODE
		 The imported node copies its target and data values from those of the
		 source node.
			 TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE
		 These three types of nodes inheriting from CharacterData copy their data
		 and length attributes from those of the source node.
			@param importedNode The node to import.
			@param deep If true, recursively import the subtree under the specified
		 node; if false, import only the node itself, as explained above. This
		 has no effect on Attr, EntityReference, and Notation nodes.
				@return The imported node that belongs to this Document.

		@short    Introduced in DOM Level 2
	*/
	public native Node importNode(Node importedNode, boolean deep);
	/**	
			 not part of the DOM
		     		@short
	*/
	public native boolean isHTMLDocument();
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentRange interface
				@return Range
 The initial state of the Range returned from this method is such that
 both of its boundary-points are positioned at the beginning of the
 corresponding Document, before any content. The Range returned can only
 be used to select content associated with this Document, or with
 DocumentFragments and Attrs for which this Document is the ownerDocument.
     
		@short    Introduced in DOM Level 2  This method is from the DocumentRange interface
	*/
	public native Range createRange();
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentTraversal interface
			 Create a new NodeIterator over the subtree rooted at the specified node.
			@param root The node which will be iterated together with its children.
		 The iterator is initially positioned just before this node. The
		 whatToShow flags and the filter, if any, are not considered when setting
		 this position. The root must not be null.
			@param whatToShow This flag specifies which node types may appear in the
		 logical view of the tree presented by the iterator. See the description
		 of NodeFilter for the set of possible SHOW_ values. These flags can be
		 combined using OR.
			@param filter The NodeFilter to be used with this NodeIterator, or null to
		 indicate no filter.
			@param entityReferenceExpansion The value of this flag determines
		 whether entity reference nodes are expanded.
				@return NodeIterator The newly created NodeIterator.

		@short    Introduced in DOM Level 2  This method is from the DocumentTraversal interface
	*/
	public native NodeIterator createNodeIterator(Node root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentTraversal interface
			 Create a new TreeWalker over the subtree rooted at the specified node.
			@param root The node which will serve as the root for the TreeWalker.
		 The whatToShow flags and the NodeFilter are not considered when setting
		 this value; any node type will be accepted as the root. The currentNode
		 of the TreeWalker is initialized to this node, whether or not it is
		 visible. The root functions as a stopping point for traversal methods
		 that look upward in the document structure, such as parentNode and
		 nextNode. The root must not be null.
			@param whatToShow This flag specifies which node types may appear in the
		 logical view of the tree presented by the tree-walker. See the
		 description of NodeFilter for the set of possible SHOW_ values. These
		 flags can be combined using OR.
			@param filter The NodeFilter to be used with this TreeWalker, or null to
		 indicate no filter.
			@param entityReferenceExpansion If this flag is false, the contents of
		 EntityReference nodes are not presented in the logical view.
				@return The newly created TreeWalker.

		@short    Introduced in DOM Level 2  This method is from the DocumentTraversal interface
	*/
	public native TreeWalker createTreeWalker(Node root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentEvent interface
			 The createEvent method is used in creating Events when it is either
		 inconvenient or unnecessary for the user to create an Event themselves.
		 In cases where the implementation provided Event is insufficient, users
		 may supply their own Event implementations for use with the
		 dispatchEvent method.
			@param eventType The eventType parameter specifies the type of Event
		 interface to be created. If the Event interface specified is supported
		 by the implementation this method will return a new Event of the
		 interface type requested. If the Event is to be dispatched via the
		 dispatchEvent method the appropriate event init method must be called
		 after creation in order to initialize the Event's values. As an example,
		 a user wishing to synthesize some kind of UIEvent would call createEvent
		 with the parameter "UIEvents". The initUIEvent method could then be
		 called on the newly created UIEvent to set the specific type of UIEvent
		 to be dispatched and set its context information.
				@return The newly created EventExceptions

		@short    Introduced in DOM Level 2  This method is from the DocumentEvent interface
	*/
	public native Event createEvent(String eventType);
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentView interface
			 The default AbstractView for this Document, or null if none available.
		     		@short    Introduced in DOM Level 2  This method is from the DocumentView interface
	*/
	public native AbstractView defaultView();
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentStyle interface
			 A list containing all the style sheets explicitly linked into or
		 embedded in a document. For HTML documents, this includes external style
		 sheets, included via the HTML LINK element, and inline STYLE elements.
		 In XML, this includes external style sheets, included via style sheet
		 processing instructions (see [XML-StyleSheet]).
		     		@short    Introduced in DOM Level 2  This method is from the DocumentStyle interface
	*/
	public native ArrayList styleSheets();
	/**	
		 CSS3 mechanism for selecting alternate stylesheets using the DOM.
		 Might change without further notice.
		     		@short    CSS3 mechanism for selecting alternate stylesheets using the DOM.
	*/
	public native String preferredStylesheetSet();
	public native String selectedStylesheetSet();
	public native void setSelectedStylesheetSet(String aString);
	/**	
				@return The KHTML view widget of this document.
     
		@short
	*/
	public native KHTMLView view();
	/**	
		 Introduced in DOM Level 2
		 This method is from the DocumentCSS interface
			 This method is used to retrieve the override style declaration for a
		 specified element and a specified pseudo-element.
			@param elt The element whose style is to be modified. This parameter
		 cannot be null.
			@param pseudoElt The pseudo-element or null if none.
				@return The override style declaration.
     
		@short    Introduced in DOM Level 2  This method is from the DocumentCSS interface
	*/
	public native CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt);
	/**	
		 Introduced in DOM Level 3
		 This method is from the DocumentLS interface
			 Indicates whether the method DocumentLS.load() should be synchronous or
		 asynchronous. When the async attribute is set to true the load method
		 returns control to the caller before the document has completed loading.
		 The default value of this attribute is true.
		     		@short    Introduced in DOM Level 3  This method is from the DocumentLS interface
	*/
	public native boolean async();
	/**	
		 Introduced in DOM Level 3
		 This method is from the DocumentLS interface
			 see async
				@short    Introduced in DOM Level 3  This method is from the DocumentLS interface
	*/
	public native void setAsync(boolean arg1);
	/**	
		 Introduced in DOM Level 3
		 This method is from the DocumentLS interface
			 If the document is currently being loaded as a result of the method load
		 being invoked the loading and parsing is immediately aborted. The
		 possibly partial result of parsing the document is discarded and the
		 document is cleared.
		     		@short    Introduced in DOM Level 3  This method is from the DocumentLS interface
	*/
	public native void abort();
	/**	
		 Introduced in DOM Level 3
		 This method is from the DocumentLS interface
			 Replaces the content of the document with the result of parsing the
		 given URI. Invoking this method will either block the caller or return
		 to the caller immediately depending on the value of the async attribute.
		 Once the document is fully loaded a "load" event (as defined in
		 [DOM Level 3 Events], except that the Event.targetNode will be the
		 document, not an element) will be dispatched on the document. If an
		 error occurs, an implementation dependent "error" event will be
		 dispatched on the document. If this method is called on a document that
		 is currently loading, the current load is interrupted and the new URI
		 load is initiated.
			 When invoking this method the parameters used in the DOMParser interface
		 are assumed to have their default values with the exception that the
		 parameters "entities", "normalize-characters",
		 "check-character-normalization" are set to "false".
			 The result of a call to this method is the same the result of a call to
		 DOMParser.parseWithContext with an input stream referencing the URI that
		 was passed to this call, the document as the context node, and the
		 action ACTION_REPLACE_CHILDREN.
			@param uri of type DOMString
		 The URI reference for the XML file to be loaded. If this is a relative
		 URI, the base URI used by the implementation is implementation dependent.
				@return If async is set to true load returns true if the document load
 was successfully initiated. If an error occurred when initiating the
 document load, load returns false.
 If async is set to false load returns true if the document was
 successfully loaded and parsed. If an error occurred when either loading
 or parsing the URI, load returns false.
     
		@short    Introduced in DOM Level 3  This method is from the DocumentLS interface
	*/
	public native void load(String uri);
	/**	
		 Introduced in DOM Level 3
		 This method is from the DocumentLS interface
			 Replace the content of the document with the result of parsing the input
		 string, this method is always synchronous. This method always parses
		 from a DOMString, which means the data is always UTF-16. All other
		 encoding information is ignored.
			 The parameters used in the DOMParser interface are assumed to have their
		 default values when invoking this method.
			 The result of a call to this method is the same the result of a call to
		 DOMParser.parseWithContext with an input stream containing the string
		 passed to this call, the document as the context node, and the action
		 ACTION_REPLACE_CHILDREN.
			@param source A string containing an XML document.
				@return true if parsing the input string succeeded without errors,
 otherwise false.
     
		@short    Introduced in DOM Level 3  This method is from the DocumentLS interface
	*/
	public native void loadXML(String source);
	/**	
		 not part of the official DOM
			 Documents are read-only by default, but they can be made editable by
		 entering "design mode".
				@return whether this document is in design mode.

		@short    not part of the official DOM
	*/
	public native boolean designMode();
	/**	
		 not part of the official DOM
			@param enable <code>true</code> to enable design mode, <code>false</code> to disable.
				@short    not part of the official DOM 
		@see #designMode
	*/
	public native void setDesignMode(boolean enable);
	/**	
		 not part of the DOM
			 completes a given URL
		     		@short    not part of the DOM
	*/
	public native String completeURL(String url);
	/**	
		 not part of the DOM
			 Updates the rendered display after one or more changes to
		 the DOM structure
		     		@short    not part of the DOM
	*/
	public native void updateRendering();
	// DOM::Document* Document(DOM::DocumentImpl* arg1); >>>> NOT CONVERTED
}
