/***************************************************************************
                            kde_KWordWrap.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KWORDWRAP
#define KDE_KWORDWRAP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.

 Usage: call the static method, @ref formatText, with the text to
 wrap and the constraining rectangle etc., it will return an instance of KWordWrap
 containing internal data, result of the word-wrapping.
 From that instance you can retrieve the boundingRect, and invoke drawing.

 This design allows to call the word-wrap algorithm only when the text changes
 and not every time we want to know the bounding rect or draw the text.
 
 @short *
 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.
*/

/** *

*/
#ifdef __cplusplus
extern   "C" {
#endif
qt_QRect* kde_KWordWrap_boundingRect(kde_KWordWrap* instPointer);

/** *

*/
qt_QString * kde_KWordWrap_wrappedString(kde_KWordWrap* instPointer);

/** *

*/
qt_QString * kde_KWordWrap_truncatedString(kde_KWordWrap* instPointer,int dots);

/** *
 Draw the text that has been previously wrapped, at position x,y.
 Flags are for alignment, e.g. AlignHCenter. Default is AlignAuto.
     
*/
void kde_KWordWrap_drawText(kde_KWordWrap* instPointer,qt_QPainter * painter, int x, int y, int flags);

/** *
 Main method for wrapping text.

*/
kde_KWordWrap* kde_KWordWrap_formatText( qt_QFontMetrics * fm, qt_QRect* r, int flags, qt_QString * str, int len);

#ifdef __cplusplus
}
#endif
#endif
