/***************************************************************************
                            kde_KPropertiesDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROPERTIESDIALOG
#define KDE_KPROPERTIESDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The main properties dialog class.
 A Properties Dialog is a dialog which displays various information
 about a particular file or URL, or several ones.
 This main class holds various related classes, which are instantiated in
 the form of tab entries in the tabbed dialog that this class provides.
 The various tabs themselves will let the user view or change information
 about the file or URL.

 This class must be created with (void)new KPropertiesDialog(...)
 It will take care of deleting itself.
 
 @short *
 The main properties dialog class.
*/

/** *
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.  Normally you will use this
 method rather than the one below.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KPropertiesDialog * kde_new_KPropertiesDialog(kde_KFileItem* item, qt_QWidget * parent, char* name, int modal, int autoShow);

/** *
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.

*/
kde_KPropertiesDialog * kde_new_KPropertiesDialog1(kde_KFileItemList* _items, qt_QWidget * parent, char* name, int modal, int autoShow);

/** *

 Brings up a Properties dialog. Convenience constructor for
 non-file-manager applications.

 Brings up a Properties dialog. Convenience constructor for
 non-file-manager applications.

*/
kde_KPropertiesDialog * kde_new_KPropertiesDialog2(kde_KURL* _url, qt_QWidget * parent, char* name, int modal, int autoShow);

/** *
 Creates a properties dialog for a new .desktop file (whose name
 is not known yet), based on a template. Special constructor for
 "File / New" in file-manager applications.

*/
kde_KPropertiesDialog * kde_new_KPropertiesDialog3(kde_KURL* _tempUrl, kde_KURL* _currentDir, qt_QString * _defaultName, qt_QWidget * parent, char* name, int modal, int autoShow);

/** *
 Creates an empty properties dialog (for applications that want use
 a standard dialog, but for things not doable via the plugin-mechanism).

*/
kde_KPropertiesDialog * kde_new_KPropertiesDialog4(qt_QString * title, qt_QWidget * parent, char* name, int modal);

/** *
 Cleans up the properties dialog and frees any associated resources,
 including the dialog itself. Note that when a properties dialog is
 closed it cleans up and deletes itself.
   
*/
void kde_del_KPropertiesDialog( kde_KPropertiesDialog* p );

/** *
 Adds a "3rd party" properties plugin to the dialog.  Useful
 for extending the properties mechanism.

 To create a new plugin type, inherit from the base class KPropsPlugin
 and implement all the methods. If you define a service .desktop file
 for your plugin, you do not need to call insertPlugin().

*/
void kde_KPropertiesDialog_insertPlugin(kde_KPropertiesDialog* instPointer,kde_KPropsDlgPlugin* plugin);

/** *

*/
kde_KURL* kde_KPropertiesDialog_kurl(kde_KPropertiesDialog* instPointer);

/** *

*/
kde_KFileItem* kde_KPropertiesDialog_item(kde_KPropertiesDialog* instPointer);

/** *

*/
kde_KFileItemList* kde_KPropertiesDialog_items(kde_KPropertiesDialog* instPointer);

/** *

   
*/
kde_KDialogBase* kde_KPropertiesDialog_dialog(kde_KPropertiesDialog* instPointer);
kde_KDialogBase* kde_KPropertiesDialog_dialog1(kde_KPropertiesDialog* instPointer);

/** *
 If we are building this dialog from a template,

*/
kde_KURL* kde_KPropertiesDialog_currentDir(kde_KPropertiesDialog* instPointer);

/** *
 If we are building this dialog from a template,

*/
qt_QString * kde_KPropertiesDialog_defaultName(kde_KPropertiesDialog* instPointer);

/** *
 Updates the item url (either called by rename or because
 a global apps/mimelnk desktop file is being saved)
 Can only be called if the dialog applies to a single file/URL.

*/
void kde_KPropertiesDialog_updateUrl(kde_KPropertiesDialog* instPointer,kde_KURL* _newUrl);

/** *
 #see FilePropsPlugin::applyChanges
 Can only be called if the dialog applies to a single file/URL.

*/
void kde_KPropertiesDialog_rename(kde_KPropertiesDialog* instPointer,qt_QString * _name);

/** *
 To abort applying changes.
   
*/
void kde_KPropertiesDialog_abortApplying(kde_KPropertiesDialog* instPointer);

/** *

*/
void kde_KPropertiesDialog_showFileSharingPage(kde_KPropertiesDialog* instPointer);

/** *
 Called when the user presses 'Ok'.
   
*/
void kde_KPropertiesDialog_slotOk(kde_KPropertiesDialog* instPointer);
void kde_KPropertiesDialog_slotCancel(kde_KPropertiesDialog* instPointer);

/** *

*/
int kde_KPropertiesDialog_canDisplay( kde_KFileItemList* _items);
void kde_KPropertiesDialog_virtual_hook(kde_KPropertiesDialog* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
