/***************************************************************************
                            kde_KMimeMagic.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMIMEMAGIC
#define KDE_KMIMEMAGIC

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 May be removed in KDE 4.0
 Determine auto-magically the type of file,
 not only by using its extension, but also by reading its contents.

 Unless specified otherwise, KMimeMagic uses
 $KDEDIR/share/mimelnk/magic for this purpose.

 To make KMimeMagic restore the 'atime' of a file after it opened it,
 add its directory in kmimemagicrc like:
 [Settings]
 atimeDirs=/tmp,/var/tmp,/home/dfaure/tmp
 This isn't done by default because it changes the 'ctime'.
 See kmimemagic.cpp for a full discussion on this issue.

 The basic usage of KMimeMagic is :

 The result is contained in the class @ref KMimeMagicResult.
 
 @short *

*/

/** *
 Create a parser and initialize it with the KDE-global data:
 the "magic" config file as well as the snippets from share/config/magic.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KMimeMagic * kde_new_KMimeMagic();

/** *
 Create a parser and initialize it with the given config file.
   
*/
kde_KMimeMagic * kde_new_KMimeMagic1(qt_QString * configFile);

/** *
 Destroy the parser.
   
*/
void kde_del_KMimeMagic( kde_KMimeMagic* p );

/** *
 Merge an existing parse table with the data from the
 given file.

*/
int kde_KMimeMagic_mergeConfig(kde_KMimeMagic* instPointer,qt_QString * configFile);

/** *
 Merge an existing parse table with the data from the
 given buffer.

*/
int kde_KMimeMagic_mergeBufConfig(kde_KMimeMagic* instPointer,char* arg1);

/** *
 Enable/Disable follow-links.

 (Default is disabled.)
   
*/
void kde_KMimeMagic_setFollowLinks(kde_KMimeMagic* instPointer,int _enable);

/** *
 Try to find a MimeType for the given file.

 If no special
 MimeType is found, the default MimeType is returned.
 This function looks at the content of the file.

*/
kde_KMimeMagicResult* kde_KMimeMagic_findFileType(kde_KMimeMagic* instPointer,qt_QString * _filename);

/** *
 Same functionality as above, except data is not
 read from a file.

 Instead a buffer can be supplied which
 is examined.

*/
kde_KMimeMagicResult* kde_KMimeMagic_findBufferType(kde_KMimeMagic* instPointer,qt_QByteArray* p);

/** *
 Same functionality as @ref findBufferType() but with
 additional capability of distinguishing between
 C-headers and C-Source.

 For this purpose this function looks
 at the extension of the filename. This means that 'filename'
 can be a filename on some FTP server, too.

*/
kde_KMimeMagicResult* kde_KMimeMagic_findBufferFileType(kde_KMimeMagic* instPointer,qt_QByteArray* arg1, qt_QString * filename);

/** *
 Returns a pointer to the unique KMimeMagic instance in this process.
   
*/
kde_KMimeMagic* kde_KMimeMagic_self( );

/** *
 The result type.
   
*/
void kde_KMimeMagic_initStatic( );

#ifdef __cplusplus
}
#endif
#endif
