/***************************************************************************
                            kde_KDatePicker.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDATEPICKER
#define KDE_KDATEPICKER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Provides a widget for calendar date input.

     Different from the
     previous versions, it now emits two types of signals, either
     @ref dateSelected() or @ref dateEntered() (see documentation for both
     signals).

     A line edit has been added in the newer versions to allow the user
     to select a date directly by entering numbers like 19990101
     or 990101.

 \image html kdatepicker.png "KDE Date Widget"

 @author Tim Gilman, Mirko Boehm

 @version $Id: kde_KDatePicker.h,v 1.5 2002/12/30 14:37:05 geiseri Exp $

 @short A date selection widget.

*/

/** * The usual constructor.  The given date will be displayed
 initially.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDatePicker * kde_new_KDatePicker(qt_QWidget * parent, qt_QDate * arg1, char* name);

/** * The usual constructor.  The given date will be displayed
 initially.

*/
kde_KDatePicker * kde_new_KDatePicker1(qt_QWidget * parent, qt_QDate * arg1, char* name, int f);

/** *
 Standard qt widget constructor. The initial date will be the
 current date.

*/
kde_KDatePicker * kde_new_KDatePicker2(qt_QWidget * parent, char* name);

/** *
 The destructor.

*/
void kde_del_KDatePicker( kde_KDatePicker* p );

/** * The size hint for date pickers. The size hint recommends the
   minimum size of the widget so that all elements may be placed
  without clipping. This sometimes looks ugly, so when using the
  size hint, try adding 28 to each of the reported numbers of
  pixels.

*/
qt_QSize * kde_KDatePicker_sizeHint(kde_KDatePicker* instPointer);

/** *
 Sets the date.

*/
int kde_KDatePicker_setDate(kde_KDatePicker* instPointer,qt_QDate * arg1);

/** *
 Returns the selected date.

*/
qt_QDate * kde_KDatePicker_getDate(kde_KDatePicker* instPointer);

/** *

*/
qt_QDate * kde_KDatePicker_date(kde_KDatePicker* instPointer);

/** *
 Enables or disables the widget.

*/
void kde_KDatePicker_setEnabled(kde_KDatePicker* instPointer,int arg1);

/** *
 Sets the font size of the widgets elements.

*/
void kde_KDatePicker_setFontSize(kde_KDatePicker* instPointer,int arg1);

/** *
 Returns the font size of the widget elements.
   
*/
int kde_KDatePicker_fontSize(kde_KDatePicker* instPointer);

/** *
 By calling this method with @p enable = true, KDatePicker will show
 a little close-button in the upper button-row. Clicking the
 close-button will cause the KDatePicker's topLevelWidget()'s close()
 method being called. This is mostly useful for toplevel datepickers
 without a window manager decoration.

*/
void kde_KDatePicker_setCloseButton(kde_KDatePicker* instPointer,int enable);

/** *

*/
int kde_KDatePicker_hasCloseButton(kde_KDatePicker* instPointer);
int kde_KDatePicker_eventFilter(kde_KDatePicker* instPointer,qt_QObject * o, qt_QEvent * e);
void kde_KDatePicker_virtual_hook(kde_KDatePicker* instPointer,int identifier, void* data);
void kde_KDatePicker_dateChangedSlot(kde_KDatePicker* instPointer,qt_QDate * arg1);
void kde_KDatePicker_tableClickedSlot(kde_KDatePicker* instPointer);
void kde_KDatePicker_monthForwardClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_monthBackwardClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_yearForwardClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_yearBackwardClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_selectWeekClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_selectMonthClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_selectYearClicked(kde_KDatePicker* instPointer);
void kde_KDatePicker_lineEnterPressed(kde_KDatePicker* instPointer);

#ifdef __cplusplus
}
#endif
#endif
