/***************************************************************************
                            kde_KButtonBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KBUTTONBOX
#define KDE_KBUTTONBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Container widget for buttons. 

 This class uses Qt layout control to place the buttons; can handle
 both vertical and horizontal button placement.  The default border
 is now @p 0 (making it easier to deal with layouts). The space
 between buttons is now more Motif compliant.

 @author Mario Weilguni <mweilguni@sime.com>

 @version $Id: kde_KButtonBox.h,v 1.5 2002/12/30 14:37:05 geiseri Exp $

 @short *
 Container widget for buttons.
*/

/** *
 Create an empty container for buttons.

 If @p _orientation is @p Vertical, the buttons inserted with 
 @ref addButton() are laid out from top to bottom, otherwise they 
 are laid out from left to right.
    
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KButtonBox * kde_new_KButtonBox(qt_QWidget * parent, int _orientation, int border, int _autoborder);

/** *
 Free private data field
    
*/
void kde_del_KButtonBox( kde_KButtonBox* p );

/** *

 This size is
 calculated by the width/height of all buttons plus border/autoborder.
    
*/
qt_QSize * kde_KButtonBox_sizeHint(kde_KButtonBox* instPointer);

/** *
 Add a new @ref QPushButton.  

*/
qt_QPushButton* kde_KButtonBox_addButton(kde_KButtonBox* instPointer,qt_QString * text, int noexpand);

/** *
 Add a new @ref QPushButton.  

*/
qt_QPushButton* kde_KButtonBox_addButton1(kde_KButtonBox* instPointer,qt_QString * text, qt_QObject * receiver, char* slot, int noexpand);

/** *
 Add a stretch to the buttonbox. 

 Can be used to separate buttons.  That is, if you add the
 buttons OK and Cancel, add a stretch, and then add the button Help,
 the buttons OK and Cancel will be left-aligned (or top-aligned
 for vertical) whereas Help will be right-aligned (or
 bottom-aligned for vertical).

*/
void kde_KButtonBox_addStretch(kde_KButtonBox* instPointer,int scale);

/** *
 This function must be called @em once after all buttons have been
 inserted.

 It will start layout control.
    
*/
void kde_KButtonBox_layout(kde_KButtonBox* instPointer);

/** *

*/
qt_QSize * kde_KButtonBox_bestButtonSize(kde_KButtonBox* instPointer);
void kde_KButtonBox_placeButtons(kde_KButtonBox* instPointer);
qt_QSize * kde_KButtonBox_buttonSizeHint(kde_KButtonBox* instPointer,qt_QPushButton* arg1);
void kde_KButtonBox_virtual_hook(kde_KButtonBox* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
