/*****************************************************************

Copyright (c) 1996-2003 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qapplication.h>
#include <qpainter.h>

#include <kconfig.h>
#include <kglobal.h>
#include <kglobalsettings.h>

#include "kicker.h"

#include "zoombutton.h"
#include "zoombutton.moc"

ZoomButton::ZoomButton()
  : PanelButtonBase( 0, 0, WStyle_Customize | WX11BypassWM | WMouseNoMask)
{
    watch = 0;
    zooming = FALSE;
    locked = 0;
    hideTimer = 0;
    _oldCursor = cursor();
    qApp->installEventFilter( this );
    setMouseTracking( TRUE );
    connect( Kicker::kicker(), SIGNAL( configurationChanged() ),
	     this, SLOT(reconfigure() ) );
    reconfigure();
}

ZoomButton::~ZoomButton()
{
    qApp->removeEventFilter( this );
}

void ZoomButton::reconfigure()
{
    KConfig* config = KGlobal::config();
    config->setGroup("buttons");
    zooming = config->readBoolEntry("EnableIconZoom", false);
    readAnimatedIconsConfig();
}

void ZoomButton::readAnimatedIconsConfig()
{
    KConfigGroup cfgGroup( KGlobal::config(), "PanelIcons" );
    doAnimations = cfgGroup.readBoolEntry( "Animated", true );
}

void ZoomButton::updateIcon()
{
    if ( watch ) 
    {
        _icon = watch->zoomIcon();
        update();
    }	
}

// Overload because regular unsetCursor() does not work for toplevel widgets
void ZoomButton::unsetCursor()
{
    setCursor(_oldCursor);
}

bool ZoomButton::isWatching( PanelButtonBase* btn )
{
    return ( btn == watch );
}

void ZoomButton::watchMe( PanelButtonBase* btn )
{
    PanelButtonBase* watch_old = watch;
    watch = btn;
    _icon = watch->zoomIcon();
    if ( watch_old ) 
    {
	watch_old->repaint(false);
	disconnect(watch_old,0, this,0);
    }
    connect(watch, SIGNAL(iconChanged()), this, SLOT(updateIcon()));
    hide();
    resize( _icon.size() );
    int offset = 5;
    QPoint p = watch->center() - rect().center();
    if ( p.x() < offset )
	p.rx() = offset;
    if ( p.y() < offset )
	p.ry() = offset;
    if ( p.x() + width() > qApp->desktop()->width() - offset)
	p.rx() = qApp->desktop()->width() - width() - offset;
    if ( p.y() + height() > qApp->desktop()->height() - offset)
	p.ry() = qApp->desktop()->height() - height() - offset;
    move( p );
    mypos = p;
    setDown( false );

    if (_icon.mask())
	setMask(* _icon.mask());
    else	
        clearMask();

    raise();
    show();
    setEnabled(true);
}

void ZoomButton::drawButtonLabel(QPainter *p)
{
    if ( isDown() || isOn() )
	move ( mypos + QPoint(2,2) );
    else
	move ( mypos );
    if ( !_icon.isNull()) {
	int x = (width() - _icon.width())/2;
	int y = (height() - _icon.height())/2;
	p->drawPixmap(x, y, _icon);
    }
}

/* This event filter is very tricky and relies on Qt
   internals. It's written this way to make all panel buttons work
   without modification and to keep advanced functionality like tool
   tips for the buttons alive.

   Don't hack around in this filter unless you REALLY know what you
   are doing. In case of doubt, ask ettrich@kde.org.
*/
bool ZoomButton::eventFilter( QObject *o, QEvent * e)
{

    if ( !watch )
	return FALSE;
    if ( e == locked )
	return FALSE;
    if ( !isVisible() )
	return FALSE;
    if ( e->type() == QEvent::Leave ) {
	if ( !hideTimer )
	    hideTimer = startTimer( 200 );
    }

    if ( o == this ) {
	if ( e->type() == QEvent::Timer && ((QTimerEvent*)e)->timerId() == hideTimer ) {
	    if ( watch && watch->isDown() )
		return TRUE;
	    QPoint globalPos = QCursor::pos();
	    if ( !geometry().contains( globalPos ) ) {
		killTimer( hideTimer );
		hideTimer = 0;
		hide();
                PanelButtonBase* btn = watch;
                watch = 0;
		if ( btn )
		    btn->update();
	    }
	    return TRUE;
	}

	if ( e->type() == QEvent::MouseButtonPress )
	    raise();

	(void) event( e ); // send to us directly , below we'll  hide the event from the tooltip filters


	if ( e->type() == QEvent::MouseButtonPress ||
	     e->type() == QEvent::MouseButtonRelease ||
	     e->type() == QEvent::MouseMove ) {
	    QMouseEvent* ev = (QMouseEvent*) e;
	    if ( rect().contains( ev->pos() ) && watch && !watch->rect().contains( ev->pos() ) )
		ev = new QMouseEvent( ev->type(),
				      watch->rect().center(),
				      ev->globalPos(),
				      ev->button(),
				      ev->state() );
	    locked = e;
	    QApplication::sendEvent( watch, ev );
	    if ( ev != e )
		delete ev;
	    locked = 0;
	}

	if ( e->type() == QEvent::Enter || e->type() == QEvent::Leave ) {
	    locked = e;
	    QApplication::sendEvent( watch, e );
	    locked = 0;
	}



	return TRUE;
    }
    if ( watch == o && e != locked ) {
	if ( e->type() == QEvent::MouseButtonPress ||
	     e->type() == QEvent::MouseButtonRelease ||
	     e->type() == QEvent::MouseMove ||
	     e->type() == QEvent::Enter ||
	     e->type() == QEvent::Leave ) {
	    QApplication::sendEvent( this, e );
	    return TRUE;
	}
    }
    return FALSE;
}

void ZoomButton::unFocus() 
{
    hide();
    if (watch) {
	PanelButtonBase* tmp = watch;
        watch = 0;
	tmp->update();
    }	
    lower();
    setEnabled(false);
}

