/*
 *   kdeprintfax - a small fax utility
 *   Copyright (C) 2001  Michael Goffioul
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef KDEPRINTFAX_H
#define KDEPRINTFAX_H

#include <kmainwindow.h>
#include <kurl.h>

class KListBox;
class QLineEdit;
class QTextEdit;
class FaxCtrl;
class QLabel;
class KOpenWithHandler;
class QTimeEdit;
class QComboBox;
class QPushButton;

class KdeprintFax : public KMainWindow
{
	Q_OBJECT
public:
	KdeprintFax(QWidget *parent = 0, const char *name = 0);
	~KdeprintFax();

	void addURL(KURL url);
	void setPhone(QString phone);
	void sendFax( bool quitAfterSend );
	QStringList files();
	QString number() const;
	QString name() const;
	QString enterprise() const;
	QString comment() const;
	QString time() const;
	QString subject() const;

protected slots:
	void slotToggleMenuBar();
	void slotKab();
	void slotAdd();
	void slotRemove();
	void slotFax();
	void slotAbort();
	void slotMessage(const QString&);
	void slotFaxSent(bool);
	void slotViewLog();
	void slotConfigure();
	void slotQuit();
	void slotView();
	void slotTimeComboActivated(int);
	void slotMoveUp();
	void slotMoveDown();
	void slotCurrentChanged();
    void slotConfigureKeys();

protected:
	void initActions();
	void dragEnterEvent(QDragEnterEvent*);
	void dropEvent(QDropEvent*);
	void updateState();

private:
	KListBox	*m_files;
	QLineEdit	*m_number, *m_name, *m_enterprise, *m_subject;
	QTextEdit	*m_comment;
	FaxCtrl		*m_faxctrl;
	QLabel		*m_msglabel;
	KOpenWithHandler	*m_handler;
	QTimeEdit	*m_time;
	QComboBox	*m_timecombo;
	QPushButton *m_upbtn, *m_downbtn;
	bool m_quitAfterSend;
};

#endif
