/*
    Copyright (C) 2001-2003 KSVG Team
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kdebug.h>

#include "SVGStyleElementImpl.h"

using namespace KSVG;

#include "SVGStyleElementImpl.lut.h"
#include "ksvg_scriptinterpreter.h"
#include "ksvg_bridge.h"
#include "ksvg_ecma.h"

SVGStyleElementImpl::SVGStyleElementImpl(DOM::ElementImpl *impl) : SVGElementImpl(impl)
{
	KSVG_EMPTY_FLAGS
}

SVGStyleElementImpl::~SVGStyleElementImpl()
{
}

void SVGStyleElementImpl::setXmlspace(const DOM::DOMString &xmlspace)
{
	m_xmlspace = xmlspace;
}

DOM::DOMString SVGStyleElementImpl::xmlspace() const
{
	return m_xmlspace;
}

void SVGStyleElementImpl::setType(const DOM::DOMString &type)
{
	m_type = type;
}

DOM::DOMString SVGStyleElementImpl::type() const
{
	return m_type;
}

void SVGStyleElementImpl::setMedia(const DOM::DOMString &media)
{
	m_media = media;
}

DOM::DOMString SVGStyleElementImpl::media() const
{
	return m_media;
}

void SVGStyleElementImpl::setTitle(const DOM::DOMString &title)
{
	m_title = title;
}

DOM::DOMString SVGStyleElementImpl::title() const
{
	return m_title;
}

// Ecma stuff

/*
@begin SVGStyleElementImpl::s_hashTable 5
 xmlspace		SVGStyleElementImpl::Xmlspace		DontDelete
 type   		SVGStyleElementImpl::Type			DontDelete
 media			SVGStyleElementImpl::Media			DontDelete
 title			SVGStyleElementImpl::Title			DontDelete
@end
*/

Value SVGStyleElementImpl::getValueProperty(ExecState *, int token) const
{
	//KSVG_CHECK_ATTRIBUTE

	switch(token)
	{
		case Xmlspace:
			return String(m_xmlspace);
		case Type:
			return String(m_type);
		case Media:
			return String(m_media);
		case Title:
			return String(m_title);
		default:
			kdWarning() << "Unhandled token in " << k_funcinfo << " : " << token << endl;
			return Undefined();
	}
}

void SVGStyleElementImpl::putValueProperty(KJS::ExecState *exec, int token, const KJS::Value &value, int)
{
	switch(token)
	{
		case Xmlspace:
			m_xmlspace = value.toString(exec).string();
			break;
		case Type:
			m_type = value.toString(exec).string();
			break;
		case Media:
			m_media = value.toString(exec).string();
			break;
		case Title:
			m_title = value.toString(exec).string();
			break;
		default:
			kdWarning() << "Unhandled token in " << k_funcinfo << " : " << token << endl;
			break;
	}
}

// vim:ts=4:noet
