#ifndef PROPERTIES_H
#define PROPERTIES_H

#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qbrush.h>
#include <qpen.h>

#include <kdialogbase.h>

class QPixmap;

class fillPropertiesWidget : public QWidget
{
  Q_OBJECT

public:
  fillPropertiesWidget(QWidget *parent);
  QBrush &brush();

public slots:
  void setFillColour();

private:
  QComboBox *patternBox;
  QLabel *patternLabel;
  QLabel *customPatternLabel;
  QLineEdit *customPatternField;
  QPushButton *browseButton;
  QPushButton *setFillColourButton;
  QColor fillColour;
  QPixmap *pattern;
  QBrush b;
};


class linePropertiesWidget : public QWidget
{
  Q_OBJECT

public:
  linePropertiesWidget(QWidget *parent);
  QPen &pen();

public slots:
  void setLineColour();

private:
  QComboBox *styleBox;
  QLabel *styleLabel;
  QComboBox *widthBox;
  QLabel *widthLabel;
  QComboBox *endTypeBox;
  QLabel *endTypeLabel;
  QComboBox *joinStyleBox;
  QLabel *joinStyleLabel;
  QPushButton *setLineColourButton;
  QColor lineColour;
  QPen p;
};

class propertiesDialog  : public KDialogBase
{
  Q_OBJECT
public:
  propertiesDialog(QWidget *parent= 0, const char *name= 0);

  QBrush &brush();
  QPen &pen();
  void setPages(int);

private:
  linePropertiesWidget *lineProps;
  fillPropertiesWidget *fillProps;
};

#endif // PROPERTIES_H
