
static void ADJUST_NAME(int fd, struct DIRENT *de)
{
  int l;
  char *extension;
  
  if (zlib_mode & CM_VERBOSE)
    fprintf(stderr,"Adjust name: %s\n", de->d_name);

  l = NAMLEN(de);

  /* substitute .z by nothing */
  if (l > zlib_extlen){
    /* we ask for name-length stricly bigger than extlen, in order to
     * avoid empty file names :-) */
    extension = (de->d_name + l - zlib_extlen);
    if (strncmp(extension, zlib_ext, zlib_extlen) == 0 ){
      *extension='\0';
      if ( (zlib_getfiletype(de->d_name,fd) & PM_READ_MASK) >=
	   PM_DIR_LEAVE_COMPR) {
	if(zlib_mode & CM_VERBOSE)
	  fprintf(stderr,"Leave %s compressed\n", de->d_name);
	/* put back into place, if we "hide" these files */
	*extension=*zlib_ext;
      }
#ifdef HAVE_NAMLEN
      else
	de->d_namlen -= zlib_extlen;
#endif
    }
  }
}


#ifdef SYS_readdir

struct DIRENT *READDIR(DIR *dirp)
{
  struct DIRENT *de;

  de = real_READDIR(dirp);

  if(!de)
    return de;

  zlib_initialise();
  if(zlib_mode & ( CM_DISAB | CM_READDIR_COMPR))
    return de;
#if defined(__GLIBC__) && __GLIBC__ >= 2
  ADJUST_NAME(dirfd(dirp), de);
#else
  ADJUST_NAME(dirp->dd_fd, de);
#endif
  return de;
}

#endif

#ifdef real_GETDENTS

int GETDENTS(int fd, struct DIRENT *dirp, unsigned int count)
{
  int left;

  _zlibc_init();
  count=real_GETDENTS(fd, dirp, count);
  if(count<=0)
    return count;

  zlib_initialise();

  if(zlib_mode & ( CM_DISAB | CM_READDIR_COMPR))
    return count;

  if (zlib_mode & CM_VERBOSE)
    fprintf(stderr,"getdents\n");
  
  for(left = count;
      left;
      left -= dirp->d_reclen,
      dirp = (struct DIRENT *) ((char *)dirp + dirp->d_reclen))
    ADJUST_NAME(fd, dirp);
  return count;
}
#endif
