<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:template match="rsum" mode="dynamic-template-select">
    <html>
      <head>
        <title><xsl:value-of select="src/rsum/@title"/></title>
        <style type="text/css">
          td {
            text-align: right;
            padding: 4px;
          }
        </style>
      </head>
      <body>
        <h1><xsl:value-of select="src/rsum/@title"/></h1>
        <table>
          <xsl:for-each select="src/rsum/row">
            <tr>
              <xsl:for-each select="v">
                <td>
                  <xsl:value-of select="."/>
                </td>
              </xsl:for-each>
              <td>
                <xsl:text>sum: </xsl:text>
                <xsl:call-template name="rowsum">
                  <xsl:with-param name="row" select="v"/>
                </xsl:call-template>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>


  <xsl:template name="rowsum">
    <xsl:param name="row" select="/.."/>
    <xsl:param name="sum" select="0"/>

    <xsl:choose>
      <xsl:when test="count($row) &gt; 0">
        <xsl:variable name="s">
          <xsl:call-template name="rowsum">
            <xsl:with-param name="row" select="$row[position()&gt;1]"/>
            <xsl:with-param name="sum" select="$sum+$row[1]"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$s"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$sum"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
