/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_moment_group.h 1590 2007-11-13 07:48:13Z paultcochrane $
*/

/*! @file xmds_moment_group.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_MOMENT_GROUP_H
#define XMDS_MOMENT_GROUP_H

#include <xmds_field.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsMomentGroup
// *****************************************************************************
// *****************************************************************************

//! xmds moment group class
class xmdsMomentGroup : public xmdsField {

  public :

    //! Constructor for the xmdsMomentGroup class
    /*!
      @param yourSimulation an xmdsSimulation object
      @param yourVerboseMode a boolean
      @param yourGroupNumber an unsigned long
    */
    xmdsMomentGroup(
        const xmdsSimulation *const yourSimulation,
        const bool& yourVerboseMode,
        const unsigned long& yourGroupNumber);

  //! Destructor
  ~xmdsMomentGroup();

  //! Process elements within a moment group
  void processElement(
                      const Element *const yourElement);

  //! Adds the specified number of samples to the moment group
  void addSamples(
                  const unsigned long& n2add) const;

  //! Sets up the final geometry of the moment group
  void finaliseGeometry();

  //! Function to determine if simulation requires integrations
  bool requiresIntegrations() const;

  //! Function to determine if moment group has post-propogation ,and should force initialisation
  bool requiresInitialisation() const;

  //! Function to determine if simulation requires a complex raw vector
  bool needscomplexRawVector() const;

  private :

    const unsigned long   myGroupNumber;                   //!< The group number (of the current object?)

  list<XMLString>       myVectorNamesList;               //!< The list of vector names
  unsigned long         mySamplingSpace;                 //!< The sampling space (x-space or k-space)
  list<unsigned long>   mySamplingLatticeList;           //!< The sampling lattice list
  list<XMLString>       mySamplingMomentsList;           //!< The sampling moments list
  XMLString             mySamplingCode;                  //!< String containing the sampling code
  unsigned long         myRawSpace;                      //!< Integer representing the raw space (before post-processing)
  unsigned long         myPostSpace;                     //!< Integer representing the post space
  list<XMLString>       myPostMomentsList;               //!< List of moments in the post space
  XMLString             myPostCode;                      //!< Code for post-propagation
  list<XMLString>       myPostProcessingVectorNamesList; //!< List of vector names in post-propagation
  list<unsigned long>   myMain2PostDimList;              //!< List of dimensions from main space to post space (I think)
  list<unsigned long>   myPost2MainDimList;              //!< List of dimensions from post space to main space (I think)
  xmdsFieldGeometry     tempGeometry;                    //!< Temporary field geometry
  bool                  complexRawVector;                //!< Whether or not we have a complex raw vector
  bool                  myRequiresIntegrations;          //!< Whether or not integrations are required
  bool                  myRequiresInitialisation;        //!< Whether or not initialisation is required

  mutable unsigned long nSamples;                        //!< The number of samples to take

  //! Write the moment group defines to file
  void writeDefines(
                    FILE *const outfile) const;

  //! Write the moment group globals to file
  void writeGlobals(
                    FILE *const outfile) const;

  //! Write the moment group prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Write the moment group routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Determine the sampling space at index
  bool samplingSpace(
                     const unsigned long& index) const;

  //! Determin the post space at index
  bool postSpace(
                 const unsigned long& index) const;

  //! Return the main to post-propagation dimension
  unsigned long main2PostDim(
                             const unsigned long& index) const;

  //! Return the post-propagation to main dimension
  unsigned long post2MainDim(
                             const unsigned long& index) const;
};


#endif // XMDS_MOMENT_GROUP_H
