/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_breakpoint.h 1619 2007-11-25 03:52:46Z grahamdennis $
*/

/*! @file xmds_breakpoint.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_BREAKPOINT_H
#define XMDS_BREAKPOINT_H

#include <xmds_segment.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsBreakpoint
// *****************************************************************************
// *****************************************************************************

//! xmds break point class
class xmdsBreakpoint : public xmdsSegment {

  public :

    //! Constructor for the xmdsBreakpoint class
    /*!
      @param yourSimulation an xmdsSimulation object
      @param yourVerboseMode a boolean
    */
    xmdsBreakpoint(
       const xmdsSimulation *const yourSimulation,
       const bool& yourVerboseMode);

  //! Destructor
  ~xmdsBreakpoint();

  //! Process elements within a moment group
  void processElement(const Element *const yourElement);

  //! Whether or not the segment needs to run when the simulation is in overtime
  bool runsInOvertime() const;

  private :

    XMLString             breakpointFilename;            //!< The filename for the breakpoint file
  unsigned long         outputSpace;                 //!< The space the output will be written in (x-space or k-space)
  list<XMLString>       myVectorNamesList;             //!< The list of vector names
  bool autoIncrementFilenames;                      //!< Should the breakpoint filenames be called 1.xsil, 2.xsil, etc?

  //! Write the filter prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Write the filter routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Determine the space at index (buh?)
  bool space(
             const long unsigned int& index) const;
};


#endif // XMDS_BREAKPOINT_H
